/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Database;

import de.Ste3et_C0st.FurnitureLib.Database.Converter;
import de.Ste3et_C0st.FurnitureLib.Database.DeSerializer;
import de.Ste3et_C0st.FurnitureLib.Database.Serializer;
import de.Ste3et_C0st.FurnitureLib.Database.com.zaxxer.hikari.HikariConfig;
import de.Ste3et_C0st.FurnitureLib.Database.com.zaxxer.hikari.HikariDataSource;
import de.Ste3et_C0st.FurnitureLib.Utilitis.ExecuteTimer;
import de.Ste3et_C0st.FurnitureLib.async.ChunkData;
import de.Ste3et_C0st.FurnitureLib.async.WorldData;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;

public abstract class Database {
    public FurnitureLib plugin;
    private final HikariConfig config;
    private final HikariDataSource dataSource;
    private final Converter converter;
    public static final String TABLE_NAME = "furnitureLibData";
    private Logger logger;
    private static HashSet<Connection> connectionDebugPool = new HashSet();

    public Database(FurnitureLib instance, HikariConfig config) {
        this.plugin = instance;
        this.logger = instance.getLogger();
        this.config = config;
        this.dataSource = new HikariDataSource(config);
        this.converter = new Converter(this);
    }

    public abstract Type.DataBaseType getType();

    public HikariConfig getConfig() {
        return this.config;
    }

    public Connection getConnection() {
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection == null) {
                throw new SQLException("Unable to get a connection from the pool.");
            }
            connectionDebugPool.add(connection);
            return connection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashSet<Connection> getConnections() {
        return connectionDebugPool;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean save(String query) {
        try (Connection con = this.getConnection();){
            boolean bl;
            block14: {
                Statement stmt = con.createStatement();
                try {
                    stmt.executeUpdate(query);
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void loadAll(Type.SQLAction action) {
        for (World world : Bukkit.getWorlds()) {
            if (!Objects.nonNull(world)) continue;
            this.loadWorld(action, world);
        }
        FurnitureManager.getInstance().sendAll();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean save(ObjectID id) {
        String base64NBT = Serializer.SerializeObjectID(id);
        int x = id.getStartLocation().getBlockX() >> 4;
        int z = id.getStartLocation().getBlockZ() >> 4;
        String query = "REPLACE INTO furnitureLibData (ObjID, Data, world, `x`, `z`, `uuid`) VALUES (?, ?, ?, ?, ?, ?);";
        try (Connection con = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = con.prepareStatement(query);
                try {
                    stmt.setString(1, id.getID());
                    stmt.setString(2, base64NBT);
                    stmt.setString(3, id.getWorldName());
                    stmt.setInt(4, x);
                    stmt.setInt(5, z);
                    stmt.setString(6, id.getUUID().toString());
                    stmt.executeUpdate();
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public HashSet<ObjectID> loadQuery(Type.SQLAction action, World bukkitWorld, String query) {
        HashSet<ObjectID> idList = new HashSet<ObjectID>();
        AtomicInteger failedId = new AtomicInteger(0);
        if (Objects.isNull(query)) {
            return idList;
        }
        String worldName = bukkitWorld.getName();
        if (Objects.nonNull(bukkitWorld)) {
            try (Connection con = this.getConnection();
                 ResultSet rs = con.createStatement().executeQuery(query);){
                if (Objects.nonNull(rs) && rs.next()) {
                    do {
                        String objectSerial = rs.getString("ObjID");
                        String data = rs.getString("Data");
                        if (objectSerial.isEmpty()) continue;
                        ObjectID obj = DeSerializer.Deserialize(objectSerial, data, action, bukkitWorld);
                        if (Objects.nonNull(obj)) {
                            obj.setWorldName(worldName);
                            idList.add(obj);
                            continue;
                        }
                        failedId.incrementAndGet();
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        idList.stream().filter(Objects::nonNull).forEach(entry -> {
            if (Objects.nonNull(entry.getProjectOBJ())) {
                entry.registerBlocks();
                entry.getProjectOBJ().applyFunction((ObjectID)entry);
            }
        });
        FurnitureManager.getInstance().addObjectID(idList);
        return idList;
    }

    public <T> CompletableFuture<HashSet<ObjectID>> loadAsynchron(ChunkData chunkdata, World bukkitWorld) {
        UUID worldUUID = bukkitWorld.getUID();
        String worldName = bukkitWorld.getName();
        String query = "SELECT ObjID,Data,world FROM furnitureLibData WHERE x=" + chunkdata.getX() + " AND z=" + chunkdata.getZ() + " AND world='" + worldName + "' OR world='" + worldUUID.toString() + "'";
        CompletableFuture<HashSet<ObjectID>> future = CompletableFuture.supplyAsync(() -> this.loadQuery(Type.SQLAction.NOTHING, bukkitWorld, query));
        return future;
    }

    public HashSet<ObjectID> loadWorld(Type.SQLAction action, World bukkitWorld) {
        HashSet<ObjectID> idList = new HashSet<ObjectID>();
        String worldName = bukkitWorld.getName();
        if (!FurnitureConfig.getFurnitureConfig().isWorldIgnored(worldName)) {
            ExecuteTimer timer = new ExecuteTimer();
            UUID worldUUID = bukkitWorld.getUID();
            AtomicInteger atomic = new AtomicInteger(0);
            if (Objects.nonNull(bukkitWorld)) {
                FurnitureLib.debug("FurnitureLib try to load models for world (" + worldName + ")", 1);
                idList.addAll(this.loadQuery(action, bukkitWorld, "SELECT ObjID,Data FROM furnitureLibData WHERE world='" + worldName + "' OR world='" + worldUUID.toString() + "'"));
                double difference = timer.difference();
                double size = idList.size();
                idList.stream().forEach(entry -> atomic.addAndGet(entry.getPacketList().size()));
                if (!(size > 0.0)) {
                    FurnitureLib.debug("No Models are found in world: " + worldName, 1);
                    return idList;
                }
                FurnitureLib.debug("FurnitureLib load " + idList.size() + " models with " + atomic.get() + " entities", 1);
                double avgSpeed = (double)Math.round(difference / size * 100.0) / 100.0;
                FurnitureLib.debug("With avg speed of " + avgSpeed + " FurnitureModel/ms", 1);
                FurnitureLib.debug("It takes: " + timer.getDifference(), 1);
            }
        }
        return idList;
    }

    public <T> CompletableFuture<WorldData> loadWorldAsync(World bukkitWorld) {
        String worldName = bukkitWorld.getName();
        String worldUUID = bukkitWorld.getUID().toString();
        WorldData worldData = new WorldData(worldName);
        if (!FurnitureConfig.getFurnitureConfig().isWorldIgnored(worldName)) {
            ExecuteTimer timer = new ExecuteTimer();
            String query = "SELECT x,z FROM <table> WHERE world='<worldName>' or world='<worldUUID>'".replace("<table>", TABLE_NAME).replace("<worldName>", worldName).replace("<worldUUID>", worldUUID);
            CompletableFuture<WorldData> future = CompletableFuture.supplyAsync(() -> {
                try (Connection con = this.getConnection();
                     ResultSet rs = con.createStatement().executeQuery(query);){
                    if (Objects.nonNull(rs) && rs.next()) {
                        do {
                            int chunkX = rs.getInt("x");
                            int chunkZ = rs.getInt("z");
                            worldData.addPoint(chunkX, chunkZ);
                        } while (rs.next());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return worldData;
            });
            FurnitureLib.debug("It takes: " + timer.getDifference(), 1);
            return future;
        }
        return null;
    }

    public void delete(ObjectID objID) {
        String query = "DELETE FROM furnitureLibData WHERE ObjID = '" + objID.getID() + "'";
        try (Connection con = this.getConnection();
             Statement stmt = con.createStatement();){
            stmt.execute(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void createTable(String query) {
        try (Connection con = this.getConnection();
             Statement stmt = con.createStatement();){
            stmt.executeUpdate(query);
            FurnitureLib.debug(this.getType().name() + " createTable -> " + query, 0);
        }
        catch (SQLException e) {
            FurnitureLib.debug(this.getType().name() + " createTable: Fail", 10);
            e.printStackTrace();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }
}

