/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Database;

import com.comphenix.protocol.wrappers.EnumWrappers;
import de.Ste3et_C0st.FurnitureLib.Database.Database;
import de.Ste3et_C0st.FurnitureLib.Database.DeSerializer;
import de.Ste3et_C0st.FurnitureLib.Database.Serializer;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTCompressedStreamTools;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.Utilitis.MaterialConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.command.CommandSender;

public class Converter {
    private Database database;
    private int stepSize = 250;
    private int offset = 0;
    private int dataFiles = 0;
    private int step = 1;
    private int stepComplete = 0;
    private List<String> objID = new ArrayList<String>();

    public Converter(Database database) {
        this.database = database;
    }

    public static NBTTagCompound convertPacketItemStack(NBTTagCompound compound) {
        compound.c().stream().filter(entity -> entity != null).forEach(entity -> {
            NBTTagCompound metadata = compound.getCompound((String)entity);
            NBTTagCompound inventory = metadata.getCompound("Inventory");
            NBTTagCompound updatedInventory = new NBTTagCompound();
            EnumSet.allOf(EnumWrappers.ItemSlot.class).stream().forEach(slot -> {
                if (!inventory.getString(slot.name()).equalsIgnoreCase("NONE")) {
                    NBTTagCompound item = MaterialConverter.convertNMSItemStack(inventory.getCompound(slot.name()));
                    updatedInventory.set(slot.name(), item);
                } else {
                    updatedInventory.setString(slot.name(), "NONE");
                }
            });
            metadata.set("Inventory", updatedInventory);
            compound.set((String)entity, metadata);
        });
        return compound;
    }

    private boolean checkIfTableExist(String str) {
        if (str.isEmpty()) {
            return false;
        }
        boolean b = false;
        try (Connection con = this.database.getConnection();
             ResultSet rs = this.database.getConnection().getMetaData().getTables(null, null, str, null);){
            b = rs.next();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public void startConvert(CommandSender sender, String tableName) {
        String sql = "SELECT COUNT(*) FROM `" + tableName + "`";
        FurnitureLib.debug("Try to convert database Table: " + tableName, 10);
        if (this.checkIfTableExist(tableName)) {
            FurnitureLib.debug("FurnitureLib: Found table to convert (" + tableName + ")", 10);
            try (Connection con = this.database.getConnection();
                 ResultSet rs = con.createStatement().executeQuery(sql);){
                if (rs.next()) {
                    do {
                        if (!Objects.nonNull(rs)) continue;
                        this.dataFiles = rs.getInt(1);
                        if (this.dataFiles == 0) continue;
                        this.stepComplete = (int)Math.ceil((double)this.dataFiles / (double)this.stepSize);
                        sender.sendMessage("Convert of " + this.dataFiles + " from " + this.database.getType().name());
                        sender.sendMessage("It takes a while " + this.stepComplete + " Steps");
                        this.convert(sender, tableName);
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            FurnitureLib.debug("FurnitureLib: Found no able to convert", 1);
            FurnitureConfig.getFurnitureConfig().setFileUpdater(false);
            FurnitureLib.getInstance().saveConfig();
            FurnitureLib.getInstance().getSQLManager().loadALL();
        }
    }

    private void convert(CommandSender sender, String tableName) {
        SchedularHelper.runAsync(() -> {
            try (Connection con = this.database.getConnection();
                 ResultSet rs = con.createStatement().executeQuery("SELECT * FROM " + tableName + " LIMIT " + this.stepSize + " OFFSET " + this.offset);){
                sender.sendMessage("\u00a77Convert Models Step \u00a7e" + this.step + "/" + this.stepComplete + " start !");
                if (rs.next()) {
                    do {
                        ++this.offset;
                        if (!Objects.nonNull(rs)) continue;
                        String a = rs.getString(1);
                        String c = rs.getString(2);
                        if (a.isEmpty() || c.isEmpty() || this.objID.contains(a)) continue;
                        ByteArrayInputStream bin = new ByteArrayInputStream(Base64.getDecoder().decode(c));
                        NBTTagCompound compound = NBTCompressedStreamTools.read(bin);
                        bin.close();
                        NBTTagCompound location = compound.getCompound("Location");
                        String world = location.getString("World");
                        int chunkX = location.getInt("X") >> 4;
                        int chunkZ = location.getInt("Z") >> 4;
                        UUID uuidObj = DeSerializer.uuidFetcher(compound.getString("Owner-UUID"));
                        String uuid = "";
                        if (uuidObj != null) {
                            uuid = uuidObj.toString();
                        }
                        if (!FurnitureLib.isNewVersion()) {
                            String sql = "REPLACE INTO furnitureLibData (ObjID, Data, world, `x`, `z`, `uuid`) VALUES ('" + a + "','" + c + "','" + world + "'," + chunkX + "," + chunkZ + ",'" + uuid + "');";
                            con.createStatement().executeUpdate(sql);
                        } else {
                            if (compound.hasKey("entities")) {
                                armorStands = compound.getCompound("entities");
                                compound.set("entities", Converter.convertPacketItemStack(armorStands));
                            } else if (compound.hasKey("ArmorStands")) {
                                armorStands = compound.getCompound("ArmorStands");
                                compound.set("entities", Converter.convertPacketItemStack(armorStands));
                                compound.remove("ArmorStands");
                            }
                            String g = Base64.getEncoder().encodeToString(Serializer.armorStandtoBytes(compound));
                            String sql = "REPLACE INTO furnitureLibData (ObjID, Data, world, `x`, `z`, `uuid`) VALUES ('" + a + "','" + g + "','" + world + "'," + chunkX + "," + chunkZ + ",'" + uuid + "');";
                            con.createStatement().executeUpdate(sql);
                        }
                        this.objID.add(a);
                    } while (rs.next());
                }
                sender.sendMessage("\u00a77Convert Models Step \u00a7e" + this.step + "/" + this.stepComplete + " Finish !");
                ++this.step;
                rs.close();
                if (this.offset < this.dataFiles) {
                    this.convert(sender, tableName);
                } else {
                    sender.sendMessage("\u00a72Database Convert Finished :D");
                    FurnitureConfig.getFurnitureConfig().setFileUpdater(false);
                    FurnitureLib.getInstance().saveConfig();
                    FurnitureLib.getInstance().getSQLManager().loadALL();
                    FurnitureLib.getInstance().send("==========================================");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

