/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Crafting;

import com.google.gson.JsonObject;
import de.Ste3et_C0st.FurnitureLib.Crafting.CraftingFile;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.ModelHandler;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.Component;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.ProjectLoader;
import de.Ste3et_C0st.FurnitureLib.Utilitis.BoundingBox;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.Furniture;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.PermissionHandler;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fContainerEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fInventory;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Project {
    private String project;
    private CraftingFile file;
    private Plugin plugin;
    private Integer chunkLimit = -1;
    private HashMap<World, Integer> limitationWorld = new HashMap();
    private List<JsonObject> functionList;
    private Type.CenterType type = Type.CenterType.RIGHT;
    private boolean EditorProject = false;
    private boolean silent = false;
    private ModelHandler modelschematic = null;
    private Function<ObjectID, Furniture> furnitureObject = ProjectLoader::new;
    private YamlConfiguration configuartion = null;
    private boolean enabled = true;

    public Project(String name, Plugin plugin, InputStream craftingFile, Type.PlaceableSide side, Function<ObjectID, Furniture> functionObject) {
        if (FurnitureLib.getInstance().isEnabledPlugin()) {
            this.project = name;
            this.plugin = plugin;
            File configFile = new File(CraftingFile.getPath(name));
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
            this.configuartion = CraftingFile.loadDefaultConfig(craftingFile, configuration, CraftingFile.getPath(name));
            if (!this.configuartion.getBoolean(name + ".enabled", true)) {
                this.enabled = false;
                return;
            }
            this.file = new CraftingFile(name, this.configuartion);
            if (!this.file.isEnabledModel()) {
                return;
            }
            String configHeader = this.file.getFileHeader();
            String systemID = this.configuartion.getString(configHeader + ".system-ID", "");
            this.project = this.project.equalsIgnoreCase(systemID) ? this.project : systemID;
            this.functionList = this.file.loadFunction(configuration);
            this.furnitureObject = functionObject;
            this.modelschematic = new ModelHandler(this.getConfig(), this.getCraftingFile().getFileHeader());
            FurnitureLib.getInstance().getFurnitureManager().addProject(this);
            this.loadDefaults();
            PermissionHandler.registerPermission("furniture.craft.*", "furniture.craft." + name.toLowerCase());
            PermissionHandler.registerPermission("furniture.place.*", "furniture.place." + name.toLowerCase());
            PermissionHandler.registerPermission("furniture.sit.*", "furniture.sit." + name.toLowerCase());
        } else {
            FurnitureLib.debug("FurnitureLib is not enabled check your console!", 10);
        }
    }

    public Project(String name, Plugin plugin, InputStream craftingFile, Function<ObjectID, Furniture> functionObject) {
        this(name, plugin, craftingFile, Type.PlaceableSide.TOP, functionObject);
    }

    public Project(String name, Plugin plugin, InputStream craftingFile, Type.PlaceableSide side, Class<? extends Furniture> clazz) {
        this(name, plugin, craftingFile, side, Project.getFunctionInterface(clazz));
    }

    public Project(String name, Plugin plugin, InputStream craftingFile, Class<? extends Furniture> clazz) {
        this(name, plugin, craftingFile, Type.PlaceableSide.TOP, Objects.isNull(clazz) ? ProjectLoader::new : Project.getFunctionInterface(clazz));
    }

    public Project(String name, Plugin plugin, InputStream craftingFile) {
        this(name, plugin, craftingFile, Type.PlaceableSide.TOP, ProjectLoader::new);
    }

    public String getName() {
        return this.project;
    }

    public Project setName(String name) {
        this.project = name;
        return this;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public CraftingFile getCraftingFile() {
        return this.file;
    }

    public YamlConfiguration getConfig() {
        return this.configuartion;
    }

    public Project setCraftingFile(CraftingFile file) {
        this.file = file;
        return this;
    }

    public Type.CenterType getCenterType() {
        return this.type;
    }

    public Type.PlaceableSide getPlaceableSide() {
        return this.getModelschematic().getPlaceableSide();
    }

    public Project setPlaceableSide(Type.PlaceableSide side) {
        if (Objects.nonNull(this.modelschematic)) {
            this.modelschematic.setPlaceableSide(side);
        }
        return this;
    }

    public String getSystemID() {
        return this.getCraftingFile().getSystemID();
    }

    public boolean isEditorProject() {
        return this.EditorProject;
    }

    public Project setEditorProject(boolean b) {
        this.EditorProject = b;
        return this;
    }

    public List<JsonObject> getFunctions() {
        return this.functionList;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean haveModelSchematic() {
        return Objects.nonNull(this.modelschematic);
    }

    public void setSilent(boolean b) {
        this.silent = b;
    }

    public int getWidth() {
        BoundingBox box = this.getModelschematic().getBoundingBox();
        int width = Math.abs(box.getMax().getBlockX() - box.getMin().getBlockX());
        return width + 1;
    }

    public int getHeight() {
        BoundingBox box = this.getModelschematic().getBoundingBox();
        return (int)box.getHeight() + 1;
    }

    public int getLength() {
        BoundingBox box = this.getModelschematic().getBoundingBox();
        int length = Math.abs(box.getMax().getBlockZ() - box.getMin().getBlockZ());
        return length + 1;
    }

    public int getAmountWorld(World w) {
        return this.limitationWorld.getOrDefault(w, -1);
    }

    public int getAmountChunk() {
        return this.chunkLimit;
    }

    public Project setSize(Integer length, Integer height, Integer width, Type.CenterType type) {
        if (Objects.nonNull(this.getModelschematic())) {
            length = length - 1;
            height = height - 1;
            width = width - 1;
            Vector pos1 = new Vector();
            Vector pos2 = new Vector(width.intValue(), height.intValue(), length.intValue());
            if (type.equals((Object)Type.CenterType.RIGHT)) {
                pos2.setZ(-length.intValue());
            } else if (type.equals((Object)Type.CenterType.CENTER)) {
                width = Math.round(width / 2);
                pos1.setX(-width.intValue());
                pos2.setX(width.intValue());
                pos2.setZ(-length.intValue());
            }
            if (type.equals((Object)Type.CenterType.LEFT)) {
                pos2.setZ(-length.intValue());
                pos2.setX(-width.intValue());
            }
            this.getModelschematic().setSize(pos1, pos2);
            this.type = type;
        }
        return this;
    }

    public ModelHandler getModelschematic() {
        return this.modelschematic;
    }

    public boolean hasPermissions(Player player) {
        String name = this.getName().toLowerCase();
        if (FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)player, "furniture.place." + name)) {
            return true;
        }
        if (FurnitureLib.getInstance().getPermissionList() != null) {
            for (String s : FurnitureLib.getInstance().getPermissionList().keySet()) {
                if (!FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)player, "furniture.place.all." + s) || !FurnitureLib.getInstance().getPermissionList().get(s).contains(this.getName())) continue;
                return true;
            }
        }
        LanguageManager.send((CommandSender)player, "message.NoPermissions", new StringTranslator[0]);
        return false;
    }

    public void loadDefaults() {
        FurnitureLib.getInstance().getFurnitureConfig().getLimitManager().getTypes().forEach(entry -> entry.updateConfig(this));
    }

    public Component getDisplayNameComponent() {
        if (Objects.nonNull(this.getCraftingFile().getDisplayName())) {
            return this.getCraftingFile().getDisplayName();
        }
        return Component.text(this.getName());
    }

    public String getDisplayName() {
        return PlainTextComponentSerializer.plainText().serialize(this.getDisplayNameComponent());
    }

    public List<ObjectID> getObjects() {
        return FurnitureManager.getInstance().getObjectList().stream().filter(obj -> Type.SQLAction.REMOVE != obj.getSQLAction()).filter(obj -> obj.getProject().equalsIgnoreCase(this.getName())).collect(Collectors.toList());
    }

    public long getObjectSize() {
        return this.getObjects().size();
    }

    public Project applyFunction() {
        if (!this.isEnabled()) {
            return this;
        }
        this.getObjects().forEach(this::applyFunction);
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Project applyFunction(ObjectID obj) {
        if (Objects.isNull(this.furnitureObject)) {
            return this;
        }
        if (!this.isEnabled()) {
            return this;
        }
        try {
            obj.setFurnitureObject(this.furnitureObject.apply(obj));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public boolean isDestroyable() {
        return this.haveModelSchematic() ? this.getModelschematic().isDestroyAble() : true;
    }

    public double updateFile() {
        File file = this.getCraftingFile().filePath;
        if (this.haveModelSchematic()) {
            double prev = this.fileSize(file);
            this.getModelschematic().save(file);
            double after = this.fileSize(file);
            return prev - after;
        }
        return 0.0;
    }

    private double fileSize(File file) {
        return (double)Math.round((double)file.length() / 1024.0 * 10.0) / 10.0;
    }

    public static Function<ObjectID, Furniture> getFunctionInterface(Class<? extends Furniture> clazz) {
        return objectID -> {
            try {
                return (Furniture)clazz.getConstructor(objectID.getClass()).newInstance(objectID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        };
    }

    public void fixMetadata(ObjectID objectID) {
        if (Objects.nonNull(this.getModelschematic())) {
            this.getModelschematic().getEntityMap(objectID.getStartLocation(), objectID.getBlockFace()).stream().filter(Objects::nonNull).forEach(entry -> {
                Optional<fEntity> source = objectID.getEntityByVector(entry.getLocation().toVector());
                if (Objects.nonNull(source) && source.isPresent()) {
                    source.get().copyMetadata((fEntity)entry);
                }
            });
        }
    }

    public void fixSkull(ObjectID objectID) {
        if (Objects.nonNull(this.getModelschematic())) {
            this.getModelschematic().getEntityMap(objectID.getStartLocation(), objectID.getBlockFace().getOppositeFace()).stream().filter(Objects::nonNull).forEach(source -> {
                fEntity actorEntity;
                Optional<fEntity> actor = objectID.getEntityByVector(source.getLocation().toVector());
                if (Objects.nonNull(source) && actor.isPresent() && (actorEntity = actor.get()) instanceof fContainerEntity && ((fContainerEntity)fContainerEntity.class.cast(actorEntity)).containMaterial(Material.PLAYER_HEAD)) {
                    fContainerEntity sourceContainerEntity = (fContainerEntity)source;
                    fContainerEntity actorContainerEntity = (fContainerEntity)actorEntity;
                    sourceContainerEntity.getInventory().getStackMap().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).forEach(entry -> actorContainerEntity.getInventory().setSlot(((fInventory.EquipmentSlot)((Object)((Object)((Object)entry.getKey())))).getSlot(), ((ItemStack)entry.getValue()).clone()));
                }
            });
        }
    }

    public ObjectID createObjectID(Location location) {
        ObjectID objectID = new ObjectID(this.getName(), this.getPlugin().getName(), location);
        return objectID;
    }

    public ObjectID spawnProject(Location location) {
        return FurnitureLib.getInstance().spawn(this, location);
    }

    public String toString() {
        return this.getSystemID();
    }

    public boolean hasSkulls() {
        if (Objects.nonNull(this.getModelschematic())) {
            return this.getModelschematic().getEntityMap().values().stream().filter(entry -> {
                fContainerEntity containerEntity;
                return entry instanceof fContainerEntity && (containerEntity = (fContainerEntity)fContainerEntity.class.cast(entry)).containMaterial(Material.PLAYER_HEAD);
            }).findFirst().isPresent();
        }
        return false;
    }
}

