/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.Component;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.MiniMessage;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import de.Ste3et_C0st.FurnitureLib.Utilitis.HiddenStringUtils;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.MaterialConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CraftingFile {
    public final String systemID;
    public final File filePath;
    private final String name;
    private final String header;
    private Component displayName = Component.empty();
    private ShapedRecipe recipe;
    private boolean isDisable;
    private boolean useItemStackObject = false;
    private boolean enabledModel = false;
    private Type.PlaceableSide side = null;

    public CraftingFile(String name, YamlConfiguration fileConfiguration) {
        this.name = name;
        if (Objects.isNull(this.name) || Objects.isNull(fileConfiguration)) {
            FurnitureLib.debug("problems to load " + name, 10);
            this.filePath = null;
            this.header = null;
            this.enabledModel = false;
            this.systemID = null;
            return;
        }
        this.filePath = new File(CraftingFile.getPath(name));
        this.header = this.getHeader(fileConfiguration);
        this.enabledModel = fileConfiguration.getBoolean(this.header + ".enabled", true);
        this.systemID = fileConfiguration.getString(this.header + ".system-ID", name);
        if (!this.enabledModel) {
            return;
        }
        try {
            if (Objects.nonNull(Class.forName("org.bukkit.NamespacedKey"))) {
                this.loadCrafting(name, fileConfiguration);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String getPath(String modelName) {
        if (FurnitureLib.isNewVersion()) {
            return "plugins/" + FurnitureLib.getInstance().getName() + "/models/" + modelName + ".dModel";
        }
        return "plugins/" + FurnitureLib.getInstance().getName() + "/Crafting/" + modelName + ".yml";
    }

    public ShapedRecipe getRecipe() {
        return this.recipe;
    }

    public ItemStack getItemstack() {
        return Objects.nonNull(this.getRecipe()) ? this.getRecipe().getResult() : null;
    }

    public boolean isEnable() {
        return this.isDisable;
    }

    public boolean isEnabledModel() {
        return this.enabledModel;
    }

    public String getFileName() {
        return this.name;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public String getFileHeader() {
        return this.header;
    }

    public boolean useItemStackObject() {
        return this.useItemStackObject;
    }

    public String getHeader(YamlConfiguration configuration) {
        try {
            return (String)configuration.getConfigurationSection("").getKeys(false).toArray()[0];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.name;
        }
    }

    public void rename(Component component) {
        if (Objects.isNull(component)) {
            return;
        }
        ItemStack stack = this.getRecipe().getResult();
        FurnitureLib.getInstance().getServerFunction().displayName(stack, BungeeComponentSerializer.get().serialize(component));
    }

    public void loadCrafting(String name, YamlConfiguration configuration) {
        try {
            this.isDisable = configuration.getBoolean(this.header + ".crafting.disable", false);
            NamespacedKey key = new NamespacedKey((Plugin)FurnitureLib.getInstance(), this.name.toLowerCase());
            String[] fragements = this.returnFragment(configuration);
            AtomicInteger materialCount = new AtomicInteger(0);
            this.recipe = new ShapedRecipe(key, this.returnResult(name, configuration)).shape(new String[]{fragements[0], fragements[1], fragements[2]});
            this.returnMaterial(name, fragements, configuration).entrySet().stream().filter(c -> c.getValue() != Material.AIR).forEach(c -> {
                this.recipe.setIngredient(((Character)c.getKey()).charValue(), (Material)c.getValue());
                materialCount.addAndGet(1);
            });
            if (!this.isDisable && materialCount.get() > 0) {
                SchedularHelper.runTask(() -> {
                    if (!this.isKeyisKeyRegistered(key)) {
                        Bukkit.getServer().addRecipe((Recipe)this.recipe);
                    }
                }, true);
            }
            this.getPlaceAbleSide(configuration);
            this.loadFunction(configuration);
        }
        catch (Exception e) {
            System.err.println(this.header + " is a corrupted model File !");
            e.printStackTrace();
        }
    }

    public List<JsonObject> loadFunction(YamlConfiguration configuration) {
        ArrayList<JsonObject> jsonList = new ArrayList<JsonObject>();
        if (configuration.contains(this.header + ".projectData.functions")) {
            List stringList = configuration.getStringList(this.header + ".projectData.functions");
            for (String str : stringList) {
                try {
                    jsonList.add(new JsonParser().parse(str).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return jsonList;
    }

    private boolean isKeyisKeyRegistered(NamespacedKey key) {
        return FurnitureLib.isVersionOrAbove("1.20") ? Objects.nonNull(Bukkit.getRecipe((NamespacedKey)key)) : this.isKeyisKeyRegisteredOld(key);
    }

    private boolean isKeyisKeyRegisteredOld(NamespacedKey key) {
        Iterator it = Bukkit.getServer().recipeIterator();
        while (it.hasNext()) {
            Recipe recipe = (Recipe)it.next();
            if (!ShapedRecipe.class.isInstance(recipe) || !((ShapedRecipe)ShapedRecipe.class.cast(recipe)).getKey().equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public Type.PlaceableSide getPlaceAbleSide(YamlConfiguration configuration) {
        this.side = Type.PlaceableSide.valueOf(configuration.getString(this.header + ".PlaceAbleSide", "TOP").toUpperCase());
        return this.side;
    }

    public void saveName(Component component, ItemStack stack) {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.getFilePath());
        if (Objects.nonNull(stack)) {
            configuration.set(this.header + ".spawnItemStack", (Object)stack);
        }
        if (Objects.nonNull(component)) {
            configuration.set(this.header + ".displayName", MiniMessage.miniMessage().serialize(component));
        }
        this.displayName = component;
        try {
            configuration.save(this.getFilePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveItemStack(Component component) {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.getFilePath());
        configuration.set(this.header + ".displayName", MiniMessage.miniMessage().serialize(component));
        this.displayName = component;
        try {
            configuration.save(this.getFilePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ItemStack returnResult(String name, YamlConfiguration configuration) {
        String str;
        if (configuration.contains(this.header + ".spawnItemStack")) {
            try {
                ItemStack stack = configuration.getItemStack(this.header + ".spawnItemStack");
                if (!stack.getType().equals((Object)Material.AIR)) {
                    ItemMeta meta = stack.getItemMeta();
                    ArrayList<String> loreText = new ArrayList<String>();
                    if (meta.hasLore()) {
                        loreText.addAll(meta.getLore());
                    }
                    if (FurnitureLib.getVersionInt() > 13) {
                        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)FurnitureLib.getInstance(), "model"), PersistentDataType.STRING, (Object)this.getSystemID());
                    } else {
                        loreText.add(HiddenStringUtils.encodeString(this.getSystemID()));
                    }
                    if (!loreText.isEmpty()) {
                        meta.setLore(loreText);
                    }
                    stack.setItemMeta(meta);
                    stack.setAmount(1);
                    this.useItemStackObject = true;
                    return stack;
                }
            }
            catch (Exception e) {
                FurnitureLib.getInstance().getLogger().warning("Can't load " + this.header + ".spawnItemStack from format, use spawnMaterial");
                e.printStackTrace();
            }
        }
        Material material = FurnitureLib.getInstance().getDefaultSpawnMaterial();
        if (configuration.contains(this.header + ".spawnMaterial") && !(str = configuration.getString(this.header + ".spawnMaterial")).equalsIgnoreCase("383")) {
            material = Material.getMaterial((String)str);
        }
        this.displayName = LanguageManager.getInstance().stringConvert("<i:false>" + configuration.getString(this.header + (FurnitureLib.isNewVersion() ? ".displayName" : ".name"), this.header), new StringTranslator[0]);
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList loreText = new ArrayList();
        FurnitureLib.getInstance().getServerFunction().setDisplayName(itemMeta, BungeeComponentSerializer.get().serialize(this.displayName));
        if (itemMeta.hasLore()) {
            loreText.addAll(itemMeta.getLore());
        }
        if (configuration.contains(this.header + ".custommodeldata")) {
            try {
                itemMeta.setCustomModelData(Integer.valueOf(configuration.getInt(this.header + ".custommodeldata")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FurnitureLib.getVersionInt() > 13) {
            itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)FurnitureLib.getInstance(), "model"), PersistentDataType.STRING, (Object)this.getSystemID());
        }
        if (configuration.contains(this.header + ".itemLore") && configuration.isList(this.header + ".itemLore")) {
            configuration.getStringList(this.header + ".itemLore").stream().forEach(loreString -> loreText.add("<i:false>" + loreString));
        }
        if (!loreText.isEmpty()) {
            ArrayList componentList = Lists.newArrayList();
            loreText.stream().map(arg_0 -> CraftingFile.lambda$returnResult$4(LanguageManager.getInstance(), arg_0)).map(BungeeComponentSerializer.get()::serialize).forEach(componentList::add);
            FurnitureLib.getInstance().getServerFunction().setLore(itemMeta, componentList);
        }
        if (FurnitureLib.getVersionInt() < 14) {
            ArrayList<String> legacyLores = new ArrayList<String>();
            legacyLores.add(HiddenStringUtils.encodeString(this.getSystemID()));
            if (itemMeta.hasLore()) {
                legacyLores.addAll(itemMeta.getLore());
            }
            itemMeta.setLore(legacyLores);
        }
        if (configuration.getBoolean(this.header + ".unbreakable", false)) {
            itemMeta.setUnbreakable(true);
        }
        if (configuration.contains(this.header + ".durability") && itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage(configuration.getInt(this.header + ".durability", 0));
        }
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ATTRIBUTES});
        itemStack.setItemMeta(itemMeta);
        itemStack.setAmount(1);
        return itemStack;
    }

    private String[] returnFragment(YamlConfiguration configuartion) {
        return configuartion.getString(this.header + ".crafting.recipe", "").split(",");
    }

    private HashMap<Character, Material> returnMaterial(String s, String[] recipe, YamlConfiguration configuration) {
        List<Character> stringList = this.returnCharacters(recipe, configuration);
        HashMap<Character, Material> materialHash = new HashMap<Character, Material>();
        stringList.forEach(letter -> {
            Material material;
            String part = configuration.getString(this.header + ".crafting.index." + letter, "AIR");
            if (!FurnitureLib.isNewVersion()) {
                try {
                    int i = Integer.parseInt(part);
                    material = MaterialConverter.convertMaterial(i, (byte)0);
                }
                catch (Exception e) {
                    material = Material.getMaterial((String)part);
                }
            } else {
                material = Material.getMaterial((String)part);
            }
            materialHash.put((Character)letter, material);
        });
        return materialHash;
    }

    private List<Character> returnCharacters(String[] recipe, YamlConfiguration configuartion) {
        ArrayList<Character> stringList = new ArrayList<Character>();
        for (String str : this.returnFragment(configuartion)) {
            for (String o : str.split("(?!^)")) {
                Character character = Character.valueOf(o.charAt(0));
                if (stringList.contains(character)) continue;
                stringList.add(character);
            }
        }
        return stringList;
    }

    public void removeCrafting(ItemStack stack) {
        if (Objects.isNull(stack)) {
            return;
        }
        Iterator it = Bukkit.getServer().recipeIterator();
        if (UnmodifiableIterator.class.isInstance(it)) {
            this.removeCraftingUnmodifiable(stack);
            return;
        }
        while (it.hasNext()) {
            Recipe recipe = (Recipe)it.next();
            if (recipe == null || !recipe.getResult().equals((Object)stack)) continue;
            it.remove();
        }
    }

    public void removeCraftingUnmodifiable(ItemStack stack) {
        ArrayList<Recipe> backup = new ArrayList<Recipe>();
        Recipe resultRecipe = null;
        Iterator a = Bukkit.getServer().recipeIterator();
        while (a.hasNext()) {
            Recipe recipe = (Recipe)a.next();
            ItemStack result = recipe.getResult();
            if (!result.isSimilar(stack)) {
                backup.add(recipe);
                continue;
            }
            resultRecipe = recipe;
        }
        if (Objects.nonNull(resultRecipe)) {
            Bukkit.getServer().clearRecipes();
            for (Recipe r : backup) {
                Bukkit.getServer().addRecipe(r);
            }
        }
    }

    public static YamlConfiguration loadDefaultConfig(InputStream craftingFile, YamlConfiguration configuartion, String path) {
        YamlConfiguration yamlConfiguration;
        File yamlPath = new File(path);
        InputStreamReader inReader = new InputStreamReader(craftingFile);
        try {
            if (Objects.isNull(configuartion)) {
                configuartion = new YamlConfiguration();
            }
            configuartion.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)inReader));
            configuartion.options().copyDefaults(true);
            if (!yamlPath.exists()) {
                configuartion.save(yamlPath);
                configuartion = YamlConfiguration.loadConfiguration((File)yamlPath);
            }
            yamlConfiguration = configuartion;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)inReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return configuartion;
            }
        }
        ((Reader)inReader).close();
        return yamlConfiguration;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public void updateResult(Component component, ItemStack stack) {
        if (Objects.isNull(stack)) {
            stack = this.getItemstack().clone();
        }
        if (Objects.nonNull(component)) {
            this.displayName = component;
            if (stack.hasItemMeta()) {
                ItemMeta meta = stack.getItemMeta();
                stack.setItemMeta(FurnitureLib.getInstance().getServerFunction().setDisplayName(meta, BungeeComponentSerializer.get().serialize(this.displayName)));
            }
        }
        NamespacedKey key = new NamespacedKey((Plugin)FurnitureLib.getInstance(), this.name.toLowerCase());
        ShapedRecipe recipe = new ShapedRecipe(key, stack).shape(this.getRecipe().getShape());
        this.recipe.getIngredientMap().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).forEach(entry -> recipe.setIngredient(((Character)entry.getKey()).charValue(), ((ItemStack)entry.getValue()).getData()));
        this.recipe = recipe;
        this.saveName(this.displayName, stack.clone());
        if (!this.isDisable) {
            Bukkit.getServer().addRecipe((Recipe)this.recipe);
        }
    }

    private static /* synthetic */ Component lambda$returnResult$4(LanguageManager rec$, String x$0) {
        return rec$.stringConvert(x$0, new StringTranslator[0]);
    }
}

