/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Command;

import de.Ste3et_C0st.FurnitureLib.Command.iCommand;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.DiceOfflinePlayer;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class removeCommand
extends iCommand {
    public removeCommand(String subCommand, String ... args) {
        super(subCommand, new String[0]);
        String tab = "project:/plugin:/world:/player:/distance:/obj:/lookat/all";
        this.setTab(tab, tab, tab);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!this.hasCommandPermission(sender)) {
            return;
        }
        ArrayList<ObjectID> objectList = new ArrayList<ObjectID>(FurnitureManager.getInstance().getObjectList());
        Object filterTypes = "";
        boolean remove = true;
        if (args.length < 2) {
            this.getLHandler().sendMessage(sender, "message.WrongArgument", new StringTranslator[0]);
            return;
        }
        Predicate<ObjectID> filterPredicate = Objects::nonNull;
        filterPredicate = filterPredicate.and(entry -> Type.SQLAction.REMOVE != entry.getSQLAction());
        for (String argument : args) {
            String objectStr;
            if ((argument = argument.toLowerCase()).startsWith("plugin:") && !((String)filterTypes).contains("plugin")) {
                if (!this.hasCommandPermission(sender, ".plugin")) {
                    return;
                }
                objectStr = argument.replace("plugin:", "");
                filterTypes = "\u00a77object:\u00a7a" + objectStr + "\u00a78|";
                filterPredicate = filterPredicate.and(entry -> entry.getPlugin().equalsIgnoreCase(objectStr));
                continue;
            }
            if (argument.startsWith("obj:") && !((String)filterTypes).contains("object")) {
                if (!this.hasCommandPermission(sender, ".object")) {
                    return;
                }
                objectStr = argument.replace("obj:", "");
                filterTypes = "\u00a77object:\u00a7a" + objectStr + "\u00a78|";
                filterPredicate = filterPredicate.and(entry -> entry.getSerial().equalsIgnoreCase(objectStr));
                break;
            }
            if (argument.equalsIgnoreCase("all")) {
                if (!this.hasCommandPermission(sender, ".all")) {
                    return;
                }
                filterTypes = "\u00a7aall";
                filterPredicate = Objects::nonNull;
                break;
            }
            if (argument.equalsIgnoreCase("lookat")) {
                if (!this.hasCommandPermission(sender, ".lookat")) {
                    return;
                }
                Player p = (Player)sender;
                ObjectID obj = this.getFromSight(p.getLocation());
                if (Objects.nonNull(obj)) {
                    filterTypes = "\u00a7alookat";
                    filterPredicate = filterPredicate.and(entry -> entry.equals(obj));
                    break;
                }
                filterTypes = "\u00a7clookat";
                remove = false;
                break;
            }
            if (argument.startsWith("project:") && !((String)filterTypes).contains("project")) {
                if (!this.hasCommandPermission(sender, ".project")) {
                    return;
                }
                String project = argument.replace("project:", "");
                filterTypes = (String)filterTypes + "\u00a77project:\u00a7a" + project + "\u00a78|";
                filterPredicate = filterPredicate.and(entry -> entry.getProject().equalsIgnoreCase(project));
                continue;
            }
            if (argument.startsWith("world:") && !((String)filterTypes).contains("world")) {
                if (!this.hasCommandPermission(sender, ".world")) {
                    return;
                }
                String world = argument.replace("world:", "");
                filterPredicate = filterPredicate.and(entry -> entry.getWorldName().equalsIgnoreCase(world));
                filterTypes = (String)filterTypes + "\u00a77world:" + world + "\u00a78|";
                continue;
            }
            if (argument.startsWith("player:") && !((String)filterTypes).contains("player")) {
                if (!this.hasCommandPermission(sender, ".player")) {
                    return;
                }
                String username = argument.replace("player:", "");
                Optional<DiceOfflinePlayer> offlinePlayer = FurnitureLib.getInstance().getPlayerCache().getPlayer(username);
                if (offlinePlayer.isPresent()) {
                    filterTypes = (String)filterTypes + "\u00a77player:\u00a7a" + username + "\u00a78|";
                    filterPredicate = filterPredicate.and(entry -> entry.getUUID().equals(((DiceOfflinePlayer)offlinePlayer.get()).getUuid()));
                    continue;
                }
                filterTypes = (String)filterTypes + "\u00a77player:\u00a7c" + argument.replace("player:", "") + "\u00a78|";
                remove = false;
                break;
            }
            if (!argument.startsWith("distance:") || ((String)filterTypes).contains("distance")) continue;
            if (!this.hasCommandPermission(sender, ".distance")) {
                return;
            }
            if (!Player.class.isInstance(sender)) continue;
            Player player = (Player)Player.class.cast(sender);
            AtomicInteger distance = new AtomicInteger(0);
            try {
                distance.set(Integer.parseInt(argument.replace("distance:", "")));
                World world = player.getWorld();
                filterPredicate = filterPredicate.and(entry -> entry.getWorldName().equalsIgnoreCase(world.getName())).and(entry -> entry.getStartLocation().distance(player.getLocation()) < (double)distance.get());
                filterTypes = (String)filterTypes + "\u00a77distance:\u00a7a" + argument.replace("distance:", "") + "\u00a78|";
            }
            catch (Exception e) {
                filterTypes = (String)filterTypes + "\u00a77distance:\u00a7c" + argument.replace("distance:", "") + "\u00a78|";
            }
        }
        if (!((String)filterTypes).isEmpty() && remove) {
            AtomicInteger count = new AtomicInteger(0);
            objectList.stream().filter(filterPredicate).forEach(entry -> {
                if (Type.SQLAction.REMOVE != entry.getSQLAction()) {
                    entry.setSQLAction(Type.SQLAction.REMOVE);
                    entry.remove(false);
                    count.incrementAndGet();
                }
            });
            this.getLHandler().sendMessage(sender, "command.remove.result", new StringTranslator("filters", StringUtils.removeEnd((String)filterTypes, (String)"|")), new StringTranslator("size", "" + count.get()));
        } else if (!remove) {
            this.getLHandler().sendMessage(sender, "command.remove.result", new StringTranslator("filters", StringUtils.removeEnd((String)filterTypes, (String)"|")));
        }
    }

    private ObjectID getFromSight(Location l) {
        if (FurnitureLib.getInstance().getFurnitureManager().getObjectList().isEmpty()) {
            return null;
        }
        int i = 10;
        BlockFace face = LocationUtil.yawToFace(l.getYaw());
        for (int j = 0; j <= i; ++j) {
            Location loc = FurnitureLib.getInstance().getLocationUtil().getRelative(l, face, j, 0.0);
            if (loc.getBlock() != null && loc.getBlock().getType() != Material.AIR) {
                return null;
            }
            for (ObjectID obj : FurnitureLib.getInstance().getFurnitureManager().getObjectList()) {
                for (fEntity packet : obj.getPacketList()) {
                    double d;
                    if (!packet.getLocation().getWorld().getName().equalsIgnoreCase(loc.getWorld().getName()) || !((d = packet.getLocation().toVector().distanceSquared(loc.toVector())) <= 2.0)) continue;
                    return packet.getObjID();
                }
            }
        }
        return null;
    }
}

