/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Command;

import de.Ste3et_C0st.FurnitureLib.Command.iCommand;
import de.Ste3et_C0st.FurnitureLib.Command.objectToSide;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.Component;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.event.ClickEvent;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.event.HoverEvent;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.format.StyleSetter;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.MiniMessage;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.DiceOfflinePlayer;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class listCommand
extends iCommand {
    private int itemsEachSide = 15;
    private static final Function<String, Predicate<ObjectID>> PLUGIN = string -> objectID -> objectID.getPlugin().equalsIgnoreCase((String)string);
    private static final Function<String, Predicate<ObjectID>> WORLD = string -> objectID -> objectID.getWorld().getName().equalsIgnoreCase((String)string);
    private static final Function<UUID, Predicate<ObjectID>> PLAYER = string -> objectID -> objectID.getUUID().equals(string);
    private static final Function<String, Optional<String[]>> STRINGS_PLITTER = string -> Optional.ofNullable(string.contains(":") ? string.toLowerCase().split(":") : null);
    private static final BiFunction<Location, Integer, Predicate<ObjectID>> DISTANCE = (location, distance) -> objectID -> objectID.getWorldName().equalsIgnoreCase(location.getWorld().getName()) && location.distance(objectID.getStartLocation()) < (double)distance.intValue();
    private static final String filters = "world:/player:/distance:/plugin:";

    public listCommand(String subCommand, String ... args) {
        super(subCommand, new String[0]);
        this.setTab(filters, filters);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!this.hasCommandPermission(sender)) {
            return;
        }
        List objectList = FurnitureManager.getInstance().getAllExistObjectIDs().collect(Collectors.toList());
        HashMap predicateHashMap = new HashMap();
        AtomicInteger side = new AtomicInteger(0);
        StringBuilder argumentBuilder = new StringBuilder();
        Arrays.asList(args).stream().map(String::toLowerCase).filter(argument -> !predicateHashMap.containsKey(argument)).forEach(argument -> {
            STRINGS_PLITTER.apply((String)argument).ifPresent(returnArray -> {
                String actualString;
                if (((String[])returnArray).length == 2 && filters.contains(returnArray[0]) && this.hasCommandPermission(sender, actualString = returnArray[0])) {
                    boolean negate = returnArray[1].startsWith("!");
                    String plainString = returnArray[1].replaceFirst("!", "");
                    Predicate<ObjectID> selector = switch (returnArray[0]) {
                        case "plugin" -> negate ? PLUGIN.apply(plainString).negate() : PLUGIN.apply(plainString);
                        case "world" -> negate ? WORLD.apply(plainString).negate() : WORLD.apply(plainString);
                        case "player" -> {
                            UUID uuid;
                            Optional<DiceOfflinePlayer> offlinePlayer = FurnitureLib.getInstance().getPlayerCache().getPlayer(plainString);
                            UUID v0 = uuid = offlinePlayer.isPresent() ? offlinePlayer.get().getUuid() : null;
                            if (Objects.nonNull(uuid)) {
                                yield negate ? PLAYER.apply(uuid).negate() : PLAYER.apply(uuid);
                            }
                            yield null;
                        }
                        case "distance" -> {
                            if (Player.class.isInstance(sender)) {
                                Integer distance = Integer.parseInt(plainString);
                                Location location = ((Player)Player.class.cast(sender)).getLocation();
                                yield DISTANCE.apply(location, distance);
                            }
                            yield null;
                        }
                        default -> null;
                    };
                    if (Objects.nonNull(selector)) {
                        predicateHashMap.put(actualString, selector);
                        argumentBuilder.append((String)argument);
                    }
                }
            });
            if (argument.matches("-?(0|[1-9]\\d*)")) {
                int selectedSide = Integer.parseInt(argument);
                side.set(selectedSide);
            }
        });
        ArrayList<Component> componentList = new ArrayList<Component>();
        double maxPages = 0.0;
        if (!predicateHashMap.isEmpty()) {
            HashMap projectCounter = new HashMap();
            Predicate<ObjectID> predicate = predicateHashMap.values().stream().reduce(Predicate::and).orElse(Objects::nonNull);
            String filters = String.join((CharSequence)",", predicateHashMap.keySet().stream().collect(Collectors.toList()));
            AtomicBoolean items = new AtomicBoolean(false);
            FurnitureManager.getInstance().getProjects().forEach(entry -> projectCounter.put(entry.getName(), new AtomicInteger(0)));
            objectList.stream().filter(predicate).forEach(entry -> {
                AtomicInteger integer = (AtomicInteger)projectCounter.get(entry.getProject());
                if (Objects.nonNull(integer)) {
                    integer.incrementAndGet();
                    items.set(true);
                }
            });
            if (!items.get()) {
                this.getLHandler().sendMessage(sender, "command.list.nothing", new StringTranslator("filters", StringUtils.removeEnd((String)filters, (String)"|")));
                return;
            }
            componentList.add((Component)MiniMessage.miniMessage().deserialize("<gray>FilterTypes: [" + filters + "]"));
            int currentSide = (side.get() > 0 ? side.get() : 1) - 1;
            projectCounter.entrySet().stream().sorted((k1, k2) -> Integer.compare(((AtomicInteger)k1.getValue()).get(), ((AtomicInteger)k2.getValue()).get())).filter(entry -> ((AtomicInteger)entry.getValue()).get() > 0).skip(this.itemsEachSide * currentSide).limit(this.itemsEachSide).forEach(entry -> {
                String name = (String)entry.getKey();
                Object component = MiniMessage.miniMessage().deserialize("<dark_gray>- <yellow>" + name + " <gray>Models: <yellow>" + ((AtomicInteger)entry.getValue()).get());
                if (sender.hasPermission("furniture.command.remove.project")) {
                    component = component.append(this.getLHandler().getComponent("command.list.remove.button", new StringTranslator[0])).hoverEvent(HoverEvent.showText(this.getLHandler().getComponent("command.list.remove.hover", new StringTranslator("project", (String)entry.getKey()), new StringTranslator("filters", filters)))).clickEvent(ClickEvent.suggestCommand("/furniture remove " + ChatColor.stripColor((String)(filters.replace("|", " ") + " project:" + name))));
                }
                componentList.add((Component)component);
            });
            double count = projectCounter.values().stream().filter(entry -> entry.get() > 0).count();
            maxPages = Math.ceil(count / (double)this.itemsEachSide);
        } else {
            FurnitureManager.getInstance().getProjects().stream().sorted((k1, k2) -> k1.getDisplayName().compareTo(k2.getDisplayName())).skip(this.itemsEachSide * side.get()).limit(this.itemsEachSide).forEach(entry -> {
                StyleSetter giveComponent;
                StyleSetter<Component> component = this.getLHandler().getComponent("command.list.main.message", new StringTranslator("project", entry.getDisplayNameComponent()));
                if (sender.hasPermission("furniture.command.debug")) {
                    Component hoverComponent = this.getLHandler().getComponent("command.list.main.debug_hover", new StringTranslator("amount", "" + entry.getObjectSize()), new StringTranslator("project", entry.getName()), new StringTranslator("size", entry.getLength() + " \u00a77|\u00a7e " + entry.getHeight() + " \u00a77|\u00a7e " + entry.getWidth()), new StringTranslator("entities", "" + entry.getModelschematic().getEntityMap().size()), new StringTranslator("block_count", "" + entry.getModelschematic().getBlockMap().size()), new StringTranslator("plugin", entry.getPlugin().getName()), new StringTranslator("destroyable", "" + entry.isDestroyable()));
                    component = component.hoverEvent(HoverEvent.showText(hoverComponent));
                }
                if (sender.hasPermission("furniture.command.give")) {
                    giveComponent = this.getLHandler().getComponent("command.list.give.button", new StringTranslator[0]).clickEvent(ClickEvent.runCommand("/furniture give " + entry.getName())).hoverEvent(HoverEvent.showText(Component.empty()));
                    component = component.append((Component)giveComponent);
                }
                if (sender.hasPermission("furniture.command.recipe") && sender.hasPermission("furniture.command.recipe." + entry.getName().toLowerCase())) {
                    giveComponent = this.getLHandler().getComponent("command.list.recipe.button", new StringTranslator[0]).clickEvent(ClickEvent.runCommand("/furniture recipe " + entry.getName())).hoverEvent(HoverEvent.showText(Component.empty()));
                    component = component.append((Component)giveComponent);
                }
                if (sender.hasPermission("furniture.command.remove.project")) {
                    StyleSetter<Component> removeComponent = this.getLHandler().getComponent("command.list.remove.button", new StringTranslator[0]);
                    removeComponent = removeComponent.hoverEvent(HoverEvent.showText(this.getLHandler().getComponent("command.list.remove.hover", new StringTranslator("project", entry.getName()))));
                    removeComponent = removeComponent.clickEvent(ClickEvent.runCommand("/furniture remove project:" + entry.getName()));
                    component = component.append((Component)removeComponent);
                }
                if (sender.hasPermission("furniture.command.delete.project")) {
                    StyleSetter<Component> deleteComponent = this.getLHandler().getComponent("command.list.delete.button", new StringTranslator[0]);
                    deleteComponent = deleteComponent.hoverEvent(HoverEvent.showText(this.getLHandler().getComponent("command.list.delete.hover", new StringTranslator("project", entry.getName()))));
                    deleteComponent = deleteComponent.clickEvent(ClickEvent.runCommand("/furniture delete " + entry.getName()));
                    component = component.append((Component)deleteComponent);
                }
                componentList.add((Component)component);
            });
            double counts = FurnitureManager.getInstance().getProjects().size();
            double items = this.itemsEachSide;
            maxPages = Math.ceil(counts / items);
            argumentBuilder.append("list ");
        }
        if (!componentList.isEmpty()) {
            new objectToSide(componentList, sender, side.get(), "/furniture " + argumentBuilder.toString(), this.itemsEachSide, (int)maxPages);
            return;
        }
        LanguageManager.send(sender, "message.SideNotFound", new StringTranslator[0]);
        LanguageManager.send(sender, "message.SideNavigation", new StringTranslator("max", "" + (int)maxPages));
    }
}

