/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Command;

import com.comphenix.protocol.wrappers.EnumWrappers;
import de.Ste3et_C0st.FurnitureLib.Command.command;
import de.Ste3et_C0st.FurnitureLib.Command.iCommand;
import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.ModelFileLoader;
import de.Ste3et_C0st.FurnitureLib.NBT.CraftItemStack;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTBase;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTCompressedStreamTools;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagInt;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagString;
import de.Ste3et_C0st.FurnitureLib.Utilitis.MaterialConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class downloadCommand
extends iCommand {
    public downloadCommand(String subCommand, String ... args) {
        super(subCommand, new String[0]);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            if (args.length == 2) {
                try {
                    if (!this.hasCommandPermission(sender)) {
                        return;
                    }
                    String name = args[1];
                    URL url = new URL("http://api.dicecraft.de/furniture/download.php");
                    sender.sendMessage("\u00a77\u00a7m+-------------------\u00a77[\u00a72Download\u00a77]\u00a7m--------------------+");
                    sender.sendMessage("\u00a76Download started from: " + name);
                    this.downLoadData(name, url, sender, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (args.length == 3) {
                try {
                    if (!this.hasCommandPermission(sender)) {
                        return;
                    }
                    String name = args[1];
                    URL url = new URL("http://api.dicecraft.de/furniture/download.php");
                    sender.sendMessage("\u00a77\u00a7m+-------------------\u00a77[\u00a72Download\u00a77]\u00a7m--------------------+");
                    sender.sendMessage("\u00a76Download started from: " + name);
                    this.downLoadData(name, url, sender, args[2]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                command.sendHelp((CommandSender)((Player)sender));
                return;
            }
        }
    }

    private String normalize(String input) {
        String output = input;
        output = output.replaceAll("\u00e4", "ae");
        output = output.replaceAll("\u00f6", "oe");
        output = output.replaceAll("\u00fc", "ue");
        output = output.replaceAll("\u00df", "sz");
        output = output.replaceAll("\u00c4", "Ae");
        output = output.replaceAll("\u00d6", "Oe");
        output = output.replaceAll("\u00dc", "Ue");
        output = output.replaceAll("\u1e9e", "Sz");
        return output;
    }

    private void downLoadData(final String name, final URL url, final CommandSender sender, final String s) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean b = true;
                    URLConnection connection = url.openConnection();
                    connection.setRequestProperty("User-Agent", "FurnitureMaker/" + FurnitureLib.getInstance().getDescription().getVersion());
                    connection.setDoOutput(true);
                    PrintStream stream = new PrintStream(connection.getOutputStream());
                    stream.println("id=" + name);
                    stream.println("&spigot=1." + FurnitureLib.getVersionInt());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    stream.checkError();
                    stream.flush();
                    stream.close();
                    String line = null;
                    String config = "";
                    String playerName = "";
                    String projectName = "";
                    int i = 0;
                    while ((line = reader.readLine()) != null) {
                        if (line.equalsIgnoreCase("#NOTEXIST") || line.equalsIgnoreCase("Invalid Page")) {
                            sender.sendMessage("\u00a7cProject Not Found");
                            sender.sendMessage("\u00a77\u00a7m+------------------------------------------------+");
                            return;
                        }
                        if (line.isEmpty()) continue;
                        switch (i) {
                            case 0: {
                                config = new String(line);
                            }
                            case 1: {
                                playerName = line;
                            }
                            case 2: {
                                projectName = downloadCommand.this.normalize(line);
                            }
                        }
                        ++i;
                    }
                    if (config.equals("")) {
                        b = false;
                    }
                    if (playerName.equals("")) {
                        b = false;
                    }
                    if (projectName.equals("")) {
                        b = false;
                    }
                    if (b) {
                        sender.sendMessage("\u00a76You have downloaded: " + projectName);
                        sender.sendMessage("\u00a76With the ID: " + name);
                        sender.sendMessage("\u00a76Created from: " + playerName);
                        if (s != null) {
                            projectName = s;
                            sender.sendMessage("\u00a77Saved as Project: \u00a7e" + projectName);
                        }
                        downloadCommand.this.add(config, playerName, projectName, sender);
                    }
                    connection.getInputStream().close();
                    sender.sendMessage("\u00a77\u00a7m+------------------------------------------------+");
                }
                catch (Exception e) {
                    sender.sendMessage("\u00a7cThe FurnitureMaker Downloader has an exception");
                    sender.sendMessage("\u00a7cPlease contact the Developer");
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void add(String config, String playerName, String project, CommandSender sender) {
        try {
            config = config.trim();
            byte[] by = Base64.getUrlDecoder().decode(config);
            ByteArrayInputStream bin = new ByteArrayInputStream(by);
            NBTTagCompound compound = NBTCompressedStreamTools.read(bin);
            if (compound.hasKey("lore")) {
                if (FurnitureLib.isNewVersion()) {
                    this.convert(compound, project, sender);
                } else {
                    this.addOld(compound, project, sender);
                }
            } else {
                this.save(compound, project, sender);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addOld(NBTTagCompound compound, String project, CommandSender sender) {
        try {
            YamlConfiguration file = new YamlConfiguration();
            NBTTagCompound crafting = compound.getCompound("crafting");
            NBTTagCompound index = crafting.getCompound("index");
            NBTTagCompound lore = compound.getCompound("lore");
            String systemID = project;
            String fileHeader = project.replace(".", "");
            if (compound.hasKey("systemID")) {
                systemID = compound.getString("systemID");
            }
            if (!systemID.equalsIgnoreCase(project)) {
                systemID = project;
            }
            file.set(fileHeader + ".name", (Object)compound.getString("name"));
            file.set(fileHeader + ".system-ID", (Object)systemID);
            NBTBase base = compound.get("material");
            if (NBTTagString.class.isInstance(base)) {
                file.set(fileHeader + ".material", (Object)compound.getString("material"));
            } else if (NBTTagInt.class.isInstance(base)) {
                file.set(fileHeader + ".material", (Object)compound.getInt("material"));
            } else {
                file.set(fileHeader + ".material", (Object)FurnitureLib.getInstance().getDefaultSpawnMaterial());
            }
            file.set(fileHeader + ".glow", (Object)compound.getBoolean("glow"));
            ArrayList<String> loreText = new ArrayList<String>();
            for (Object s : lore.c()) {
                loreText.add(lore.getString((String)s));
            }
            file.set(fileHeader + ".lore", loreText);
            file.set(fileHeader + ".crafting.disable", (Object)crafting.getBoolean("disable"));
            file.set(fileHeader + ".crafting.recipe", (Object)crafting.getString("recipe"));
            for (Object s : index.c()) {
                file.set(fileHeader + ".crafting.index." + (String)s, (Object)index.getString((String)s));
            }
            if (compound.hasKey("ArmorStands")) {
                NBTTagCompound armorStands = compound.getCompound("ArmorStands");
                for (Object s : armorStands.c()) {
                    file.set(fileHeader + ".ProjectModels.ArmorStands." + (String)s, (Object)armorStands.getString((String)s));
                }
            }
            Type.PlaceableSide side = Type.PlaceableSide.TOP;
            if (compound.hasKey("PlaceAbleSide")) {
                side = Type.PlaceableSide.valueOf(compound.getString("PlaceAbleSide"));
            }
            file.set(fileHeader + ".PlaceAbleSide", (Object)side.toString());
            if (compound.hasKey("Blocks")) {
                NBTTagCompound blocks = compound.getCompound("Blocks");
                for (Object s : blocks.c()) {
                    String str = (String)s;
                    if (!blocks.hasKey(str)) continue;
                    NBTTagCompound block = blocks.getCompound(str);
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".X-Offset", (Object)block.getDouble("X-Offset"));
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".Y-Offset", (Object)block.getDouble("Y-Offset"));
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".Z-Offset", (Object)block.getDouble("Z-Offset"));
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".Type", (Object)block.getString("Type"));
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".Data", (Object)block.getInt("Data"));
                    if (!block.hasKey("gameProfile")) continue;
                    NBTTagCompound profile = block.getCompound("gameProfile");
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".gameProfile.uuid", (Object)profile.getString("uuid"));
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".gameProfile.textures.value", (Object)profile.getString("texture_value"));
                    file.set(fileHeader + ".ProjectModels.Block." + str + ".gameProfile.textures.signature", (Object)profile.getString("texture_signature"));
                }
            }
            file.save(new File("plugins/" + FurnitureLib.getInstance().getName() + "/Crafting/" + project + ".yml"));
            SchedularHelper.runAsync(() -> {
                Project projObj = ModelFileLoader.loadModelFile(new File("plugins/" + FurnitureLib.getInstance().getName() + "/Crafting/" + project + ".yml"));
                if (Objects.nonNull(projObj) && projObj.haveModelSchematic() && !projObj.getModelschematic().isDestroyAble()) {
                    this.getLHandler().sendMessage(sender, "command.download.noHitbox", new StringTranslator[0]);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save(NBTTagCompound compound, String project, CommandSender sender) throws IOException {
        String str;
        NBTTagCompound armorStands;
        YamlConfiguration file = new YamlConfiguration();
        InputStreamReader inReader = new InputStreamReader(FurnitureLib.getInstance().getResource("default.dModel"));
        file.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)inReader));
        file.options().copyDefaults(true);
        List<String> headerConfig = Arrays.asList("------------------------------------  #", "                                      #", "      never touch the system-ID !     #", "                                      #", "------------------------------------  #");
        String headerString = String.join((CharSequence)"\n", headerConfig.toArray(new String[headerConfig.size()]));
        file.options().copyHeader(true);
        file.options().header(headerString);
        NBTTagCompound crafting = compound.getCompound("crafting");
        NBTTagCompound index = crafting.getCompound("index");
        NBTTagCompound lore = crafting.getCompound("lore");
        String systemID = project;
        if (compound.hasKey("system-ID")) {
            systemID = compound.getString("system-ID");
        }
        if (!systemID.equalsIgnoreCase(project)) {
            systemID = project;
        }
        String header = project.replace(".", "");
        file.set(header + ".displayName", (Object)compound.getString("displayName"));
        file.set(header + ".system-ID", (Object)systemID);
        file.set(header + ".spawnMaterial", (Object)compound.getString("spawnMaterial"));
        if (compound.hasKey("spawnItemStack")) {
            try {
                CraftItemStack craftItemStack = new CraftItemStack();
                file.set(header + ".spawnItemStack", (Object)craftItemStack.getItemStack(compound.getCompound("spawnItemStack")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        file.set(header + ".itemGlowEffect", (Object)compound.getBoolean("itemGlowEffect"));
        ArrayList<String> loreText = new ArrayList<String>();
        for (Object s : lore.c()) {
            loreText.add(lore.getString((String)s));
        }
        file.set(header + ".itemLore", loreText);
        file.set(header + ".crafting.disable", (Object)crafting.getBoolean("disable"));
        file.set(header + ".crafting.recipe", (Object)crafting.getString("recipe"));
        for (Object s : index.c()) {
            Material mat = MaterialConverter.getMaterialFromOld(index.getString((String)s));
            file.set(header + ".crafting.index." + (String)s, (Object)mat.name());
        }
        if (compound.hasKey("entities")) {
            armorStands = compound.getCompound("entities");
            for (Object s : armorStands.c()) {
                str = armorStands.getString((String)s);
                file.set(header + ".projectData.entities." + (String)s, (Object)str);
            }
        }
        if (compound.hasKey("entitys")) {
            armorStands = compound.getCompound("entitys");
            for (Object s : armorStands.c()) {
                str = armorStands.getString((String)s);
                file.set(header + ".projectData.entities." + (String)s, (Object)str);
            }
        }
        Type.PlaceableSide side = Type.PlaceableSide.TOP;
        if (compound.hasKey("placeAbleSide")) {
            side = Type.PlaceableSide.valueOf(compound.getString("placeAbleSide"));
        }
        file.set(project + ".placeAbleSide", (Object)side.toString());
        if (compound.hasKey("blockList")) {
            NBTTagCompound blocks = compound.getCompound("blockList");
            for (Object s : blocks.c()) {
                String str2 = (String)s;
                if (!blocks.hasKey(str2)) continue;
                NBTTagCompound block = blocks.getCompound(str2);
                Object blockData = MaterialConverter.updateChangedMaterial((String)(block.hasKey("material") ? "minecraft:" + block.getString("material") : block.getString("blockData")));
                if (block.hasKey("material") && block.hasKey("Rotation")) {
                    blockData = (String)blockData + "[facing=" + block.getString("Rotation") + "]";
                }
                if (((String)blockData).isEmpty() || ((String)blockData).contains("air")) continue;
                file.set(header + ".projectData.blockList." + str2 + ".blockData", blockData);
                file.set(header + ".projectData.blockList." + str2 + ".xOffset", (Object)block.getDouble("xOffset"));
                file.set(header + ".projectData.blockList." + str2 + ".yOffset", (Object)block.getDouble("yOffset"));
                file.set(header + ".projectData.blockList." + str2 + ".zOffset", (Object)block.getDouble("zOffset"));
                if (!block.hasKey("gameProfile")) continue;
                NBTTagCompound profile = block.getCompound("gameProfile");
                file.set(header + ".projectData.blockList." + str2 + ".gameProfile.uuid", (Object)profile.getString("uuid"));
                file.set(header + ".projectData.blockList." + str2 + ".gameProfile.textures.value", (Object)profile.getString("texture_value"));
                file.set(header + ".projectData.blockList." + str2 + ".gameProfile.textures.signature", (Object)profile.getString("texture_signature"));
            }
        }
        if (compound.hasKey("function")) {
            NBTTagCompound stringList = compound.getCompound("function");
            ArrayList<String> functions = new ArrayList<String>();
            for (int j = 0; j < stringList.c().size(); ++j) {
                functions.add(stringList.getString("" + j));
            }
            file.set(header + ".projectData.functions", functions);
        }
        file.save(new File("plugins/" + FurnitureLib.getInstance().getName() + "/models/" + project + ".dModel"));
        SchedularHelper.runAsync(() -> {
            Project projObj = ModelFileLoader.loadModelFile(new File("plugins/" + FurnitureLib.getInstance().getName() + "/models/" + project + ".dModel"));
            if (Objects.nonNull(projObj) && projObj.haveModelSchematic() && !projObj.getModelschematic().isDestroyAble()) {
                this.getLHandler().sendMessage(sender, "command.download.noHitbox", new StringTranslator[0]);
            }
        });
    }

    private void convert(NBTTagCompound compound, String project, CommandSender sender) throws IOException {
        YamlConfiguration file = new YamlConfiguration();
        InputStreamReader inReader = new InputStreamReader(FurnitureLib.getInstance().getResource("default.dModel"));
        file.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)inReader));
        file.options().copyDefaults(true);
        List<String> headerConfig = Arrays.asList("------------------------------------  #", "                                      #", "      never touch the system-ID !     #", "                                      #", "------------------------------------  #");
        String headerString = String.join((CharSequence)"\n", headerConfig.toArray(new String[headerConfig.size()]));
        file.options().copyHeader(true);
        file.options().header(headerString);
        String header = project.replace(".", "").replace(":", "");
        NBTTagCompound crafting = compound.getCompound("crafting");
        NBTTagCompound index = crafting.getCompound("index");
        NBTTagCompound lore = crafting.getCompound("lore");
        String systemID = header;
        if (compound.hasKey("systemID")) {
            systemID = compound.getString("systemID");
        }
        if (!systemID.equalsIgnoreCase(header)) {
            systemID = header;
        }
        file.set(header + ".displayName", (Object)compound.getString("name"));
        file.set(header + ".system-ID", (Object)systemID);
        NBTBase base = compound.get("material");
        if (NBTTagString.class.isInstance(base)) {
            file.set(header + ".spawnMaterial", (Object)MaterialConverter.getMaterialFromOld(compound.getString("material")).name());
        } else if (NBTTagInt.class.isInstance(base)) {
            file.set(header + ".spawnMaterial", (Object)MaterialConverter.getMaterialFromOld("" + compound.getInt("material")).name());
        } else {
            file.set(header + ".spawnMaterial", (Object)FurnitureLib.getInstance().getDefaultSpawnMaterial().name());
        }
        file.set(header + ".itemGlowEffect", (Object)compound.getBoolean("glow"));
        ArrayList<String> loreText = new ArrayList<String>();
        for (Object s : lore.c()) {
            loreText.add(lore.getString((String)s));
        }
        file.set(header + ".itemLore", loreText);
        file.set(header + ".crafting.disable", (Object)crafting.getBoolean("disable"));
        file.set(header + ".crafting.recipe", (Object)crafting.getString("recipe"));
        for (Object s : index.c()) {
            Material mat = MaterialConverter.getMaterialFromOld(index.getString((String)s));
            file.set(header + ".crafting.index." + (String)s, (Object)mat.name());
        }
        if (compound.hasKey("ArmorStands")) {
            NBTTagCompound armorStands = compound.getCompound("ArmorStands");
            for (Object s : armorStands.c()) {
                String md5 = armorStands.getString((String)s);
                byte[] by = Base64.getDecoder().decode(md5);
                ByteArrayInputStream bin = new ByteArrayInputStream(by);
                try {
                    NBTTagCompound metadata = NBTCompressedStreamTools.read(bin);
                    NBTTagCompound inventory = metadata.getCompound("Inventory");
                    NBTTagCompound updatedInventory = new NBTTagCompound();
                    for (EnumWrappers.ItemSlot object : EnumWrappers.ItemSlot.values()) {
                        if (!inventory.getString(object.toString()).equalsIgnoreCase("NONE")) {
                            NBTTagCompound item = MaterialConverter.convertNMSItemStack(inventory.getCompound(object.toString()));
                            updatedInventory.set(object.toString(), item);
                            continue;
                        }
                        updatedInventory.setString(object.toString(), "NONE");
                    }
                    metadata.set("Inventory", updatedInventory);
                    byte[] out = NBTCompressedStreamTools.toByte(metadata);
                    String str = Base64.getEncoder().encodeToString(out);
                    file.set(header + ".projectData.entities." + (String)s, (Object)str);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Type.PlaceableSide side = Type.PlaceableSide.TOP;
        if (compound.hasKey("PlaceAbleSide")) {
            side = Type.PlaceableSide.valueOf(compound.getString("PlaceAbleSide"));
        }
        file.set(header + ".placeAbleSide", (Object)side.toString());
        if (compound.hasKey("Blocks")) {
            NBTTagCompound blocks = compound.getCompound("Blocks");
            for (Object s : blocks.c()) {
                String str = (String)s;
                if (!blocks.hasKey(str)) continue;
                NBTTagCompound block = blocks.getCompound(str);
                file.set(header + ".projectData.blockList." + str + ".xOffset", (Object)block.getDouble("X-Offset"));
                file.set(header + ".projectData.blockList." + str + ".yOffset", (Object)block.getDouble("Y-Offset"));
                file.set(header + ".projectData.blockList." + str + ".zOffset", (Object)block.getDouble("Z-Offset"));
                Material materialBlock = MaterialConverter.getMaterialFromOld(block.getString("Type"));
                String blockData = "minecraft:" + materialBlock.name().toLowerCase();
                if (block.hasKey("Rotation")) {
                    blockData = blockData + "[facing=" + block.getString("Rotation") + "]";
                }
                file.set(header + ".projectData.blockList." + str + ".blockData", (Object)blockData);
                if (!block.hasKey("gameProfile")) continue;
                NBTTagCompound profile = block.getCompound("gameProfile");
                file.set(header + ".projectData.blockList." + str + ".gameProfile.uuid", (Object)profile.getString("uuid"));
                file.set(header + ".projectData.blockList." + str + ".gameProfile.textures.value", (Object)profile.getString("texture_value"));
                file.set(header + ".projectData.blockList." + str + ".gameProfile.textures.signature", (Object)profile.getString("texture_signature"));
            }
        }
        String filePath = "plugins/" + FurnitureLib.getInstance().getName() + "/models/" + header + ".dModel";
        file.save(new File(filePath));
        Project projObj = ModelFileLoader.loadModelFile(new File(filePath));
        if (Objects.nonNull(projObj) && projObj.haveModelSchematic() && !projObj.getModelschematic().isDestroyAble()) {
            this.getLHandler().sendMessage(sender, "command.download.noHitbox", new StringTranslator[0]);
        }
    }
}

