/*
 * Decompiled with CFR 0.152.
 */
package code.velocity.broadcaststream;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Plugin(id="streambroadcast", name="StreamBroadcast", description="Live broadcast link", version="1.0.0", authors={"SrMast3r_"})
public class VelocityPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private final Map<Player, Instant> lastUsage = new HashMap<Player, Instant>();
    private Duration cooldownDuration;
    private Map<String, String> messages;
    private List<String> commandAliases;

    @Inject
    public VelocityPlugin(ProxyServer server, Logger logger, PluginContainer pluginContainer) {
        Map<String, Object> config;
        this.server = server;
        this.logger = logger;
        Path configDirectory = Paths.get("plugins", "StreamBroadcast");
        try {
            Files.createDirectories(configDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Could not create configuration directory", (Throwable)e);
        }
        File configFile = configDirectory.resolve("config.yml").toFile();
        if (!configFile.exists()) {
            this.createDefaultConfig(configFile);
        }
        if ((config = this.loadConfig(configFile)) == null) {
            logger.warn("Could not load configuration from config.yml.");
            this.messages = this.getDefaultMessages();
            this.commandAliases = List.of("directo", "live", "stream");
            this.cooldownDuration = Duration.ofMinutes(10L);
        } else {
            this.messages = config.getOrDefault("messages", this.getDefaultMessages());
            this.commandAliases = ((Map)config.get("commands")).getOrDefault("aliases", List.of("directo", "live", "stream"));
            int cooldownSeconds = (Integer)config.getOrDefault("cooldown", 600);
            this.cooldownDuration = Duration.ofSeconds(cooldownSeconds);
        }
    }

    private void createDefaultConfig(File configFile) {
        Yaml yaml = new Yaml();
        HashMap<String, Object> defaultConfig = new HashMap<String, Object>();
        defaultConfig.put("messages", this.getDefaultMessages());
        defaultConfig.put("commands", Map.of("aliases", List.of("directo", "live", "stream")));
        defaultConfig.put("cooldown", 600);
        try (FileWriter writer = new FileWriter(configFile);){
            yaml.dump(defaultConfig, (Writer)writer);
        }
        catch (IOException e) {
            this.logger.error("Error creating the default configuration file.", (Throwable)e);
        }
    }

    private Map<String, Object> loadConfig(File configFile) {
        Yaml yaml = new Yaml();
        try {
            return (Map)yaml.load((Reader)Files.newBufferedReader(configFile.toPath()));
        }
        catch (IOException e) {
            this.logger.error("Error loading configuration file.", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> getDefaultMessages() {
        HashMap<String, String> defaultMessages = new HashMap<String, String>();
        defaultMessages.put("invalidCommand", "<red>Incorrect command usage. You must specify a valid link.");
        defaultMessages.put("cooldownMessage", "<red>You must wait 10 minutes before using this command again.");
        defaultMessages.put("invalidLink", "<red>The link provided is not valid. Please use a link from Twitch, YouTube, Facebook, TikTok or other streaming platform.");
        defaultMessages.put("announcementFormat", "<#8bf723> \u2604 %s <white>is now live");
        defaultMessages.put("space", "");
        defaultMessages.put("linkPrefix", "<reset><white>%s");
        return defaultMessages;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        SimpleCommand broadcastCommand = new SimpleCommand(){

            public void execute(SimpleCommand.Invocation invocation) {
                CommandSource source = invocation.source();
                if (!(source instanceof Player)) {
                    source.sendMessage(MiniMessage.miniMessage().deserialize((Object)VelocityPlugin.this.centerText(VelocityPlugin.this.messages.get("invalidCommand"))));
                    return;
                }
                Player player = (Player)source;
                Instant now = Instant.now();
                Instant lastUsed = VelocityPlugin.this.lastUsage.getOrDefault(player, Instant.EPOCH);
                if (Duration.between(lastUsed, now).compareTo(VelocityPlugin.this.cooldownDuration) < 0) {
                    player.sendMessage(MiniMessage.miniMessage().deserialize((Object)VelocityPlugin.this.centerText(VelocityPlugin.this.messages.get("cooldownMessage"))));
                    return;
                }
                VelocityPlugin.this.lastUsage.put(player, now);
                String[] args = (String[])invocation.arguments();
                if (args.length != 1) {
                    player.sendMessage(MiniMessage.miniMessage().deserialize((Object)VelocityPlugin.this.centerText(VelocityPlugin.this.messages.get("invalidCommand"))));
                    return;
                }
                String streamLink = args[0];
                if (!VelocityPlugin.this.isValidStreamLink(streamLink)) {
                    player.sendMessage(MiniMessage.miniMessage().deserialize((Object)VelocityPlugin.this.centerText(VelocityPlugin.this.messages.get("invalidLink"))));
                    return;
                }
                String announcement = String.format(VelocityPlugin.this.messages.get("announcementFormat"), player.getUsername());
                String centeredLink = String.format(VelocityPlugin.this.messages.get("linkPrefix"), streamLink);
                Component spaceComponent = MiniMessage.miniMessage().deserialize((Object)VelocityPlugin.this.centerText(VelocityPlugin.this.messages.get("space")));
                Component announcementComponent = MiniMessage.miniMessage().deserialize((Object)VelocityPlugin.this.centerText(announcement));
                Component linkComponent = MiniMessage.miniMessage().deserialize((Object)VelocityPlugin.this.centerText(centeredLink)).clickEvent(ClickEvent.openUrl((String)streamLink));
                for (Player p : VelocityPlugin.this.server.getAllPlayers()) {
                    p.sendMessage(spaceComponent);
                    p.sendMessage(announcementComponent);
                    p.sendMessage(linkComponent);
                    p.sendMessage(spaceComponent);
                }
            }

            public boolean hasPermission(SimpleCommand.Invocation invocation) {
                return invocation.source().hasPermission("livebroadcast.use");
            }
        };
        for (String alias : this.commandAliases) {
            this.server.getCommandManager().register(alias, (Command)broadcastCommand, new String[0]);
        }
    }

    private boolean isValidStreamLink(String link) {
        try {
            URL url = new URL(link);
            String host = url.getHost().toLowerCase();
            return host.endsWith("twitch.tv") || host.endsWith("youtube.com") || host.endsWith("facebook.com") || host.endsWith("tiktok.com");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private String centerText(String message) {
        int chatWidth = 70;
        int messageWidth = message.length();
        int padding = (chatWidth - messageWidth) / 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < padding; ++i) {
            sb.append(" ");
        }
        sb.append(message);
        return sb.toString();
    }
}

