/*
 * Decompiled with CFR 0.152.
 */
package com.technicjelle;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class UpdateChecker {
    private final String currentVersion;
    private final URL url;
    private final boolean disabled;
    private transient CompletableFuture<String> latestVersionFuture = null;

    public UpdateChecker(@NotNull String author, @NotNull String repoName, @NotNull String currentVersion) {
        this.currentVersion = UpdateChecker.removePrefix(currentVersion);
        this.disabled = System.getProperty("technicjelle.updatechecker.disabled") != null;
        try {
            this.url = new URL("https://github.com/" + author + "/" + repoName + "/releases/latest");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void check() {
        this.checkAsync();
        this.latestVersionFuture.join();
    }

    public void checkAsync() {
        this.latestVersionFuture = CompletableFuture.supplyAsync(this::fetchLatestVersion);
    }

    public synchronized String getLatestVersion() {
        if (this.latestVersionFuture == null) {
            this.checkAsync();
        }
        return this.latestVersionFuture.join();
    }

    private String fetchLatestVersion() {
        if (this.disabled) {
            return this.currentVersion;
        }
        try {
            HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
            con.setInstanceFollowRedirects(false);
            String newUrl = con.getHeaderField("Location");
            if (newUrl == null) {
                throw new IOException("Did not get a redirect");
            }
            String[] split = newUrl.split("/");
            return UpdateChecker.removePrefix(split[split.length - 1]);
        }
        catch (IOException ex) {
            throw new CompletionException("Exception trying to fetch the latest version", ex);
        }
    }

    public boolean isUpdateAvailable() {
        return !this.getLatestVersion().equals(this.currentVersion);
    }

    public Optional<String> getUpdateMessage() {
        if (this.isUpdateAvailable()) {
            return Optional.of("New version available: v" + this.getLatestVersion() + " (current: v" + this.currentVersion + ")\nDownload it at " + this.url);
        }
        return Optional.empty();
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getUpdateUrl() {
        return this.url.toString();
    }

    public void logUpdateMessage(@NotNull Logger logger) {
        this.getUpdateMessage().ifPresent(logger::warning);
    }

    public synchronized void logUpdateMessageAsync(@NotNull Logger logger) {
        if (this.latestVersionFuture == null) {
            this.checkAsync();
        }
        this.latestVersionFuture.thenRun(() -> this.logUpdateMessage(logger));
    }

    @Contract(pure=true)
    @NotNull
    private static String removePrefix(@NotNull String version) {
        return version.replaceFirst("^v", "");
    }
}

