/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.managers;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.listeners.PlayerListener;
import com.armamc.plugincontrol.managers.ConfigManager;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PluginsManager {
    private final PluginControl plugin;
    private final ConfigManager config;
    private final MessageManager message;
    private PlayerListener playerListener;

    public PluginsManager(@NotNull PluginControl plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
        this.message = plugin.getMessageManager();
    }

    public void checkPlugins() {
        if (!this.config.isEnabled()) {
            this.message.send(this.message.getCheckingDisabled(), new TagResolver[0]);
            return;
        }
        this.message.send(this.message.getCheckingMessage(), new TagResolver[0]);
        HashSet<String> missingPlugins = new HashSet<String>();
        for (String pluginName : this.config.getPluginList()) {
            if (this.plugin.isPluginEnabled(pluginName)) continue;
            missingPlugins.add(pluginName);
        }
        HashSet<String> missingGroups = new HashSet<String>();
        Map<String, Set<String>> pluginGroup = this.config.getPluginGroups();
        for (Map.Entry<String, Set<String>> groups : pluginGroup.entrySet()) {
            boolean groupHasEnabledPlugin = false;
            if (groups.getValue().isEmpty()) continue;
            for (String pluginName : groups.getValue()) {
                if (!this.plugin.isPluginEnabled(pluginName)) continue;
                groupHasEnabledPlugin = true;
                break;
            }
            if (groupHasEnabledPlugin) continue;
            missingGroups.add(groups.getKey());
        }
        if (!missingPlugins.isEmpty() || !missingGroups.isEmpty()) {
            this.registerAction(missingPlugins, missingGroups);
        } else {
            this.message.send(this.message.getCheckFinished(), new TagResolver[0]);
        }
    }

    private void registerAction(@NotNull Set<String> missingPlugins, @NotNull Set<String> missingGroups) {
        TagResolver.Single pluginTag = null;
        if (!missingPlugins.isEmpty()) {
            pluginTag = Placeholder.component((String)"plugins", (ComponentLike)this.message.getPluginListComponent(missingPlugins));
        }
        TagResolver.Single groupTag = null;
        if (!missingGroups.isEmpty()) {
            groupTag = Placeholder.component((String)"groups", (ComponentLike)this.message.getGroupListComponent(missingGroups));
        }
        switch (ConfigManager.ActionType.from(this.config.getAction().toLowerCase())) {
            case DISALLOW_PLAYER_LOGIN: {
                this.handleDisallowPlayerLogin(pluginTag, groupTag);
                break;
            }
            case LOG_TO_CONSOLE: {
                this.logToConsole(pluginTag, groupTag);
                break;
            }
            case SHUTDOWN_SERVER: {
                this.shutdownServer(pluginTag, groupTag);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action: %s".formatted(this.config.getAction()));
            }
        }
    }

    private void handleDisallowPlayerLogin(TagResolver.Single pluginTag, TagResolver.Single groupTag) {
        if (this.playerListener == null) {
            this.playerListener = new PlayerListener(this.plugin);
            this.playerListener.init();
        }
        this.logToConsole(pluginTag, groupTag);
    }

    private void shutdownServer(TagResolver.Single pluginTag, TagResolver.Single groupTag) {
        this.logToConsole(pluginTag, groupTag);
        this.message.send(this.message.getDisablingServer(), new TagResolver[0]);
        this.plugin.getServer().shutdown();
    }

    private void logToConsole(TagResolver.Single pluginTag, TagResolver.Single groupTag) {
        if (pluginTag != null) {
            this.message.send(this.message.getLogToConsolePlugin(), new TagResolver[]{pluginTag});
        }
        if (groupTag != null) {
            this.message.send(this.message.getLogToConsoleGroup(), new TagResolver[]{groupTag});
        }
        this.message.send(this.message.getCheckFinished(), new TagResolver[0]);
    }

    public void unregisterListener() {
        if (this.playerListener != null) {
            PlayerLoginEvent.getHandlerList().unregister((Plugin)this.plugin);
            this.playerListener = null;
        }
    }
}

