/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.managers;

import com.armamc.plugincontrol.PluginControl;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MessageManager {
    private final PluginControl plugin;
    private FileConfiguration lang;
    private MiniMessage mm;
    private static final String LANG_FILE_NAME = "lang.yml";

    public MessageManager(PluginControl plugin) {
        this.plugin = plugin;
        this.loadLang();
    }

    public void loadLang() {
        File langFile = new File(this.plugin.getDataFolder(), LANG_FILE_NAME);
        if (!langFile.exists()) {
            this.plugin.getLogger().info("Creating the lang.yml file!");
            this.plugin.saveResource(LANG_FILE_NAME, false);
        }
        this.lang = YamlConfiguration.loadConfiguration((File)langFile);
        this.reloadLang();
    }

    public void reloadLang() {
        File langFile = new File(this.plugin.getDataFolder(), LANG_FILE_NAME);
        this.lang = YamlConfiguration.loadConfiguration((File)langFile);
        InputStream defConfigStream = this.plugin.getResource(LANG_FILE_NAME);
        if (defConfigStream == null) {
            return;
        }
        YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8));
        for (String key : defConfig.getKeys(true)) {
            if (this.lang.contains(key)) continue;
            this.lang.set(key, defConfig.get(key));
        }
        this.saveLang();
        this.mm = MiniMessage.builder().tags(TagResolver.builder().resolver(StandardTags.defaults()).resolver((TagResolver)this.prefix()).build()).postProcessor(c -> c.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.NOT_SET)).build();
    }

    public void saveLang() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.lang.save(new File(this.plugin.getDataFolder(), LANG_FILE_NAME));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not save lang.yml file!");
            }
        });
    }

    public void send(@NotNull CommandSender sender, @NotNull String message) {
        if (!message.isBlank()) {
            this.plugin.adventure().sender(sender).sendMessage(this.mm.deserialize((Object)message));
        }
    }

    public void send(@NotNull CommandSender sender, @NotNull String message, TagResolver ... tags) {
        if (!message.isBlank()) {
            this.plugin.adventure().sender(sender).sendMessage(this.mm.deserialize(message, tags));
        }
    }

    public void send(@NotNull CommandSender sender, @NotNull List<String> message, @NotNull TagResolver tag) {
        if (!message.isEmpty()) {
            message.stream().filter(Predicate.not(String::isBlank)).map(line -> this.mm.deserialize(line, tag)).forEach(line -> this.plugin.adventure().sender(sender).sendMessage(line));
        }
    }

    public void send(@NotNull String message, TagResolver ... tags) {
        if (!message.isBlank()) {
            Component component = this.mm.deserialize(message, tags);
            this.plugin.adventure().sender((CommandSender)Bukkit.getConsoleSender()).sendMessage(component);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.hasPermission("plugincontrol.notify")) continue;
                this.plugin.adventure().sender((CommandSender)player).sendMessage(component);
            }
        }
    }

    @NotNull
    public Component getPluginListComponent(@NotNull Set<String> pluginList) {
        JoinConfiguration joinConfiguration = JoinConfiguration.separators((ComponentLike)this.mm.deserialize((Object)this.getPluginListSeparator()), (ComponentLike)this.mm.deserialize((Object)this.getPluginListSeparatorLast()));
        ArrayList<Component> componentList = new ArrayList<Component>();
        if (!pluginList.isEmpty()) {
            for (String pluginName : pluginList) {
                String color = this.plugin.isPluginEnabled(pluginName) ? this.getPluginEnabledColor() : this.getPluginDisabledColor();
                componentList.add(this.mm.deserialize((Object)(color + pluginName)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.mm.deserialize((Object)this.getPluginClickRemove()))).clickEvent(ClickEvent.callback(c -> this.plugin.getConfigManager().removePlugin(pluginName))));
            }
        }
        return Component.join((JoinConfiguration)joinConfiguration, componentList);
    }

    @NotNull
    public Component getGroupListComponent(@NotNull Set<String> groupList) {
        JoinConfiguration joinConfiguration = JoinConfiguration.separators((ComponentLike)this.mm.deserialize((Object)this.getPluginListSeparator()), (ComponentLike)this.mm.deserialize((Object)this.getPluginListSeparatorLast()));
        ArrayList<Component> componentList = new ArrayList<Component>();
        if (!groupList.isEmpty()) {
            for (String groupName : groupList) {
                componentList.add(this.mm.deserialize((Object)groupName).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.mm.deserialize((Object)this.getGroupClickDelete()))).clickEvent(ClickEvent.callback(c -> this.plugin.getConfigManager().removeGroup(groupName))));
            }
        }
        return Component.join((JoinConfiguration)joinConfiguration, componentList);
    }

    @NotNull
    public Component getGroupListComponent(@NotNull Map<String, Set<String>> pluginGroups) {
        if (pluginGroups.isEmpty()) {
            return this.mm.deserialize((Object)this.getGroupListEmpty());
        }
        ArrayList<Component> componentList = new ArrayList<Component>();
        String groupCommand = "/plugincontrol group list %s";
        List sortedGroups = pluginGroups.entrySet().stream().sorted(Map.Entry.comparingByKey(String.CASE_INSENSITIVE_ORDER)).toList();
        for (Map.Entry groupEntry : sortedGroups) {
            String groupName = (String)groupEntry.getKey();
            componentList.add(Component.newline().append(this.mm.deserialize(this.getGroupListName(), (TagResolver)Placeholder.parsed((String)"group", (String)groupName)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.mm.deserialize((Object)this.getGroupClickInfo()))).clickEvent(ClickEvent.runCommand((String)groupCommand.formatted(groupName)))));
            TreeSet plugins = ((Set)groupEntry.getValue()).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toCollection(TreeSet::new));
            ArrayList<Component> pluginComponents = new ArrayList<Component>();
            if (!plugins.isEmpty()) {
                JoinConfiguration joinConfiguration = (JoinConfiguration)JoinConfiguration.builder().separator((ComponentLike)this.mm.deserialize((Object)this.getPluginListSeparator())).lastSeparator((ComponentLike)this.mm.deserialize((Object)this.getPluginListSeparatorLast())).build();
                String pluginCommand = "/plugincontrol group remove %s %s";
                for (String pluginName : plugins) {
                    String color = this.plugin.isPluginEnabled(pluginName) ? this.getPluginEnabledColor() : this.getPluginDisabledColor();
                    pluginComponents.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.mm.deserialize((Object)(color + pluginName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.mm.deserialize((Object)this.getGroupClickRemovePlugin())))).clickEvent(ClickEvent.runCommand((String)pluginCommand.formatted(groupName, pluginName)))).asComponent());
                }
                componentList.add(((TextComponent)((TextComponent)Component.text((String)" [").color((TextColor)NamedTextColor.GRAY)).append(Component.join((JoinConfiguration)joinConfiguration, pluginComponents))).append(Component.text((String)"]").color((TextColor)NamedTextColor.GRAY)));
                continue;
            }
            componentList.add(Component.text((String)" [ ]").color((TextColor)NamedTextColor.GRAY));
        }
        return Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.empty()), componentList);
    }

    public Component deserialize(String string) {
        return this.mm.deserialize((Object)string);
    }

    public String serialize(String string) {
        return LegacyComponentSerializer.builder().hexColors().build().serialize(this.mm.deserialize((Object)string));
    }

    @Contract(value=" -> new")
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TagResolver.Single prefix() {
        return Placeholder.parsed((String)"prefix", (String)this.lang.getString("prefix", "<dark_gray>[<red>PluginControl<dark_gray>]"));
    }

    public String getKickMessage() {
        String kick = "kick-message";
        if (this.lang.getString(kick) == null) {
            this.setKickMessage("<red>[PluginControl] You are not allowed to join the server!");
        }
        return this.lang.getString(kick);
    }

    public void setKickMessage(String kickMessage) {
        this.lang.set("kick-message", (Object)kickMessage);
        this.saveLang();
    }

    public List<String> getHelpList() {
        return this.lang.getStringList("command.help");
    }

    public String getPluginEnabled() {
        return this.lang.getString("command.plugin-enabled");
    }

    public String getPluginDisabled() {
        return this.lang.getString("command.plugin-disabled");
    }

    public String getPluginAdded() {
        return this.lang.getString("command.plugin-added");
    }

    public String getAllPluginsAdded() {
        return this.lang.getString("command.plugin-added-all");
    }

    public String getPluginAlreadyAdded() {
        return this.lang.getString("command.plugin-already-added");
    }

    public String getPluginAddError() {
        return this.lang.getString("command.plugin-add-error");
    }

    public String getPluginListEmpty() {
        return this.lang.getString("command.plugin-list-empty");
    }

    public String getPluginRemoveError() {
        return this.lang.getString("command.plugin-remove-error");
    }

    public String getPluginRemoved() {
        return this.lang.getString("command.plugin-removed");
    }

    public String getPluginNotFound() {
        return this.lang.getString("command.plugin-not-found");
    }

    public String getPluginList() {
        return this.lang.getString("command.plugin-list");
    }

    public String getActionType() {
        return this.lang.getString("command.action-type");
    }

    public String getActionSet() {
        return this.lang.getString("command.action-set");
    }

    public String getActionTypeList() {
        return this.lang.getString("command.action-list");
    }

    public String getKickMessageInfo() {
        return this.lang.getString("command.kick-message");
    }

    public String getKickMessageSet() {
        return this.lang.getString("command.kick-message-set");
    }

    public String getPluginReloaded() {
        return this.lang.getString("command.plugin-reload");
    }

    public String getCheckingMessage() {
        return this.lang.getString("console.checking-plugins");
    }

    public String getCheckingDisabled() {
        return this.lang.getString("console.plugin-disabled");
    }

    public String getCheckFinished() {
        return this.lang.getString("console.finished-checking");
    }

    public String getLogToConsolePlugin() {
        return this.lang.getString("console.log-to-console-plugin");
    }

    public String getLogToConsoleGroup() {
        return this.lang.getString("console.log-to-console-group");
    }

    public String getDisablingServer() {
        return this.lang.getString("console.disabling-server");
    }

    public String getPluginListSeparator() {
        return this.lang.getString("command.plugin-list-separator");
    }

    public String getPluginListSeparatorLast() {
        return this.lang.getString("command.plugin-list-separator-last");
    }

    public String getPluginEnabledColor() {
        return this.lang.getString("command.plugin-list-enabled-color");
    }

    public String getPluginDisabledColor() {
        return this.lang.getString("command.plugin-list-disabled-color");
    }

    public String getPluginClickRemove() {
        return this.lang.getString("command.plugin-click-remove");
    }

    public List<String> getGroupHelp() {
        return this.lang.getStringList("command.group-help");
    }

    public String getGroupCreateError() {
        return this.lang.getString("command.group-create-error");
    }

    public String getGroupCreated() {
        return this.lang.getString("command.group-created");
    }

    public String getGroupAlreadyExist() {
        return this.lang.getString("command.group-already-exist");
    }

    public String getGroupRemoveError() {
        return this.lang.getString("command.group-remove-error");
    }

    public String getGroupRemoved() {
        return this.lang.getString("command.group-removed");
    }

    public String getGroupNotFound() {
        return this.lang.getString("command.group-not-found");
    }

    public String getGroupListEmpty() {
        return this.lang.getString("command.group-list-empty");
    }

    public String getGroupList() {
        return this.lang.getString("command.group-list");
    }

    public String getPluginAddedToGroup() {
        return this.lang.getString("command.plugin-added-to-group");
    }

    public String getPluginAddToGroupError() {
        return this.lang.getString("command.plugin-add-to-group-error");
    }

    public String getPluginRemoveFromGroupError() {
        return this.lang.getString("command.plugin-removed-from-group-error");
    }

    public String getPluginRemovedFromGroup() {
        return this.lang.getString("command.plugin-removed-from-group");
    }

    public String getPluginNotInGroupError() {
        return this.lang.getString("command.plugin-not-in-group");
    }

    public String getGroupHasNoPlugins() {
        return this.lang.getString("command.group-has-no-plugins");
    }

    public String getGroupPluginList() {
        return this.lang.getString("command.group-plugin-list");
    }

    public String getAllPluginsRemoved() {
        return this.lang.getString("command.plugin-removed-all");
    }

    public String getGroupListName() {
        return this.lang.getString("command.group-list-name");
    }

    private String getGroupClickDelete() {
        return this.lang.getString("command.group-click-delete");
    }

    public String getGroupClickRemovePlugin() {
        return this.lang.getString("command.group-click-remove-plugin");
    }

    public String getGroupClickInfo() {
        return this.lang.getString("command.group-click-info");
    }

    public String getCheckingPlugins() {
        return this.lang.getString("command.checking-plugins");
    }

    public String getCheckDependError() {
        return this.lang.getString("command.check-depend-error");
    }

    public String getCheckDependNotFound() {
        return this.lang.getString("command.check-depend-not-found");
    }

    public String getCheckDependDepend() {
        return this.lang.getString("command.check-depend-depend");
    }

    public String getCheckDependSoftDepend() {
        return this.lang.getString("command.check-depend-softdepend");
    }
}

