/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.managers;

import com.armamc.plugincontrol.PluginControl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private final PluginControl plugin;
    private final FileConfiguration config;
    private Set<String> pluginList;
    private Map<String, Set<String>> pluginGroups;

    public ConfigManager(@NotNull PluginControl plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.loadConfig();
    }

    private void loadConfig() {
        this.loadPlugins();
        this.loadGroups();
    }

    public void saveConfig() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> ((PluginControl)this.plugin).saveConfig());
    }

    public List<String> getServerPlugins() {
        return Arrays.stream(Bukkit.getPluginManager().getPlugins()).toList().stream().map(Plugin::getName).toList();
    }

    public boolean isUpdateNotifierEnabled() {
        return this.config.getBoolean("update-notifier", false);
    }

    public boolean isEnabled() {
        if (this.config.getBoolean("enabled")) {
            this.config.set("enabled", (Object)false);
            this.saveConfig();
        }
        return this.config.getBoolean("enabled");
    }

    public void setEnabled(boolean enabled) {
        this.config.set("enabled", (Object)enabled);
        this.saveConfig();
    }

    public String getAction() {
        if (this.config.getString("action") == null) {
            this.config.set("action", (Object)ActionType.LOG_TO_CONSOLE.getAction());
            this.saveConfig();
        }
        return this.config.getString("action");
    }

    public void setAction(@NotNull ActionType action) {
        this.config.set("action", (Object)action.getAction());
        this.saveConfig();
    }

    private void loadPlugins() {
        List plugins;
        this.pluginList = new HashSet<String>();
        if (this.config.contains("plugins") && !(plugins = this.config.getStringList("plugins")).isEmpty()) {
            this.pluginList.addAll(plugins);
        }
    }

    public Set<String> getPluginList() {
        return this.pluginList.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toCollection(TreeSet::new));
    }

    private void savePluginList() {
        this.config.set("plugins", new ArrayList<String>(this.pluginList));
        this.saveConfig();
    }

    public boolean addPlugin(String pluginName) {
        if (!this.pluginList.contains(pluginName)) {
            this.pluginList.add(pluginName);
            this.savePluginList();
            return true;
        }
        return false;
    }

    public void addAllPlugins(List<String> pluginName) {
        this.pluginList.addAll(pluginName);
        this.savePluginList();
    }

    public boolean removePlugin(String pluginName) {
        if (this.pluginList.contains(pluginName)) {
            this.pluginList.remove(pluginName);
            this.savePluginList();
            return true;
        }
        return false;
    }

    public void removeAllPlugins() {
        this.pluginList.clear();
        this.savePluginList();
    }

    private void loadGroups() {
        this.pluginGroups = new HashMap<String, Set<String>>();
        if (this.config.contains("groups")) {
            ConfigurationSection groupsSection = this.config.getConfigurationSection("groups");
            if (groupsSection != null) {
                Set groupNames = groupsSection.getKeys(false);
                for (String groupName : groupNames) {
                    HashSet plugins = new HashSet(this.config.getStringList("groups." + groupName));
                    this.pluginGroups.put(groupName, plugins);
                }
            }
        } else {
            this.config.createSection("groups");
        }
        this.savePluginGroup();
    }

    private void savePluginGroup() {
        for (Map.Entry<String, Set<String>> entry : this.pluginGroups.entrySet()) {
            this.config.set("groups." + entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.saveConfig();
    }

    public Map<String, Set<String>> getPluginGroups() {
        return this.pluginGroups;
    }

    public List<String> getPluginGroupList() {
        return this.pluginGroups.keySet().stream().toList();
    }

    public boolean addGroup(@NotNull String groupName) {
        if (this.pluginGroups.get(groupName) == null) {
            this.pluginGroups.put(groupName, new HashSet());
            this.savePluginGroup();
            return true;
        }
        return false;
    }

    public boolean addPluginToGroup(String groupName, String plugin) {
        if (groupName == null || groupName.isEmpty() || plugin == null || plugin.isEmpty()) {
            return false;
        }
        Set<String> existingPlugins = this.pluginGroups.get(groupName);
        if (existingPlugins == null) {
            return false;
        }
        existingPlugins.add(plugin);
        this.savePluginGroup();
        return true;
    }

    public boolean isGroupEmpty(String groupName) {
        return this.pluginGroups.get(groupName) != null && this.pluginGroups.get(groupName).isEmpty();
    }

    public boolean isGroupNonexistent(String groupName) {
        return this.pluginGroups.get(groupName) == null;
    }

    public boolean removePluginFromGroup(String groupName, String pluginName) {
        Set<String> pluginsInGroup;
        boolean removed;
        if (this.pluginGroups.containsKey(groupName) && (removed = (pluginsInGroup = this.pluginGroups.get(groupName)).removeIf(p -> p.equalsIgnoreCase(pluginName)))) {
            this.config.set("groups." + groupName, new ArrayList<String>(pluginsInGroup));
            this.saveConfig();
            return true;
        }
        return false;
    }

    public boolean removeGroup(String groupName) {
        if (this.pluginGroups.containsKey(groupName)) {
            this.pluginGroups.remove(groupName);
            this.config.set("groups." + groupName, null);
            this.savePluginGroup();
            return true;
        }
        return false;
    }

    public Set<String> getPluginsOfGroup(String groupName) {
        return this.pluginGroups.get(groupName);
    }

    public static enum ActionType {
        LOG_TO_CONSOLE("log-to-console"),
        DISALLOW_PLAYER_LOGIN("disallow-player-login"),
        SHUTDOWN_SERVER("shutdown-server");

        private final String action;
        private static final Map<String, ActionType> lookup;

        @Contract(pure=true)
        private ActionType(String action) {
            this.action = action;
        }

        @NotNull
        public static ActionType from(String action) {
            ActionType result = lookup.get(action);
            if (result == null) {
                throw new IllegalArgumentException("Unexpected value: " + action);
            }
            return result;
        }

        @Contract(pure=true)
        public String getAction() {
            return this.action;
        }

        static {
            lookup = new HashMap<String, ActionType>();
            for (ActionType actionType : ActionType.values()) {
                lookup.put(actionType.getAction(), actionType);
            }
        }
    }
}

