/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.listeners;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.Collection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerListener
implements Listener {
    private final PluginControl plugin;
    private final MessageManager message;
    private final Permission bypass;

    public PlayerListener(@NotNull PluginControl plugin) {
        this.plugin = plugin;
        this.message = plugin.getMessageManager();
        this.bypass = new Permission("plugincontrol.bypass");
    }

    public void init() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        Collection onlinePlayers = this.plugin.getServer().getOnlinePlayers();
        for (Player player : onlinePlayers) {
            if (player.hasPermission(this.bypass)) continue;
            player.kickPlayer(this.message.serialize(this.message.getKickMessage()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onPlayerLogin(@NotNull PlayerLoginEvent event) {
        if (!this.plugin.getConfigManager().isEnabled()) {
            return;
        }
        if (event.getPlayer().hasPermission(this.bypass)) {
            return;
        }
        event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.message.serialize(this.message.getKickMessage()));
    }
}

