/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.ConfigManager;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RemoveSubCommand
implements SubCommand {
    private final ConfigManager config;
    private final MessageManager message;

    @Contract(pure=true)
    public RemoveSubCommand(@NotNull PluginControl plugin) {
        this.config = plugin.getConfigManager();
        this.message = plugin.getMessageManager();
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (this.config.getPluginList().isEmpty()) {
            this.message.send(sender, this.message.getPluginListEmpty());
            return;
        }
        if (args.length == 0 || args[0].isBlank()) {
            this.message.send(sender, this.message.getPluginRemoveError(), new TagResolver[]{Placeholder.parsed((String)"command", (String)label)});
            return;
        }
        String target = args[0];
        if (target.equals("all")) {
            this.config.removeAllPlugins();
            this.message.send(sender, this.message.getAllPluginsRemoved());
            return;
        }
        if (this.config.removePlugin(target)) {
            this.message.send(sender, this.message.getPluginRemoved(), new TagResolver[]{Placeholder.parsed((String)"plugin", (String)target)});
        } else {
            this.message.send(sender, this.message.getPluginNotFound(), new TagResolver[]{Placeholder.parsed((String)"plugin", (String)target)});
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String[] args) {
        return this.config.getPluginList().stream().filter(s -> s.startsWith(args[0])).toList();
    }
}

