/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.MessageManager;
import com.armamc.plugincontrol.managers.PluginsManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ReloadSubCommand
implements SubCommand {
    private final PluginControl plugin;
    private final MessageManager message;
    private final PluginsManager manager;

    @Contract(pure=true)
    public ReloadSubCommand(@NotNull PluginControl plugin) {
        this.plugin = plugin;
        this.message = plugin.getMessageManager();
        this.manager = plugin.getPluginsManager();
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        this.manager.unregisterListener();
        this.plugin.reloadConfig();
        this.message.reloadLang();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this.manager::checkPlugins, 20L);
        this.message.send(sender, this.message.getPluginReloaded());
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String[] args) {
        return List.of();
    }
}

