/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.ConfigManager;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ListSubCommand
implements SubCommand {
    private final ConfigManager config;
    private final MessageManager message;

    @Contract(pure=true)
    public ListSubCommand(@NotNull PluginControl plugin) {
        this.config = plugin.getConfigManager();
        this.message = plugin.getMessageManager();
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (this.config.getPluginList() == null || this.config.getPluginList().isEmpty()) {
            this.message.send(sender, this.message.getPluginListEmpty());
        } else {
            this.message.send(sender, this.message.getPluginList(), new TagResolver[]{Placeholder.component((String)"plugins", (ComponentLike)this.message.getPluginListComponent(this.config.getPluginList()))});
        }
        if (this.config.getPluginGroups() == null || this.config.getPluginGroups().isEmpty()) {
            this.message.send(sender, this.message.getGroupListEmpty());
        } else {
            this.message.send(sender, this.message.getGroupList(), new TagResolver[]{Placeholder.component((String)"groups", (ComponentLike)this.message.getGroupListComponent(this.config.getPluginGroups()))});
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String[] args) {
        return List.of();
    }
}

