/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class KickMessageSubCommand
implements SubCommand {
    private final MessageManager message;

    @Contract(pure=true)
    public KickMessageSubCommand(@NotNull PluginControl plugin) {
        this.message = plugin.getMessageManager();
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String @NotNull [] args) {
        String kick = "kick-message";
        if (args.length == 0 || args[0].isBlank()) {
            this.message.send(sender, this.message.getKickMessageInfo(), new TagResolver[]{Placeholder.component((String)kick, (ComponentLike)this.message.deserialize(this.message.getKickMessage()))});
        } else {
            this.message.setKickMessage(String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length)));
            this.message.send(sender, this.message.getKickMessageSet(), new TagResolver[]{Placeholder.component((String)kick, (ComponentLike)this.message.deserialize(this.message.getKickMessage()))});
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String[] args) {
        return Stream.of("<kick message>").filter(s -> s.startsWith(args[0])).toList();
    }
}

