/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.ConfigManager;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GroupSubCommand
implements SubCommand {
    private final ConfigManager config;
    private final MessageManager message;
    private final List<String> subcommands;

    @Contract(pure=true)
    public GroupSubCommand(@NotNull PluginControl plugin) {
        this.config = plugin.getConfigManager();
        this.message = plugin.getMessageManager();
        this.subcommands = List.of("create", "delete", "list", "add", "remove", "help");
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String @NotNull [] args) {
        if (args.length == 0 || args[0].isBlank()) {
            this.message.send(sender, this.message.getGroupHelp(), (TagResolver)Placeholder.parsed((String)"command", (String)label));
            return;
        }
        String target = args[0];
        if (target.equalsIgnoreCase("create")) {
            if (args.length == 1) {
                this.message.send(sender, this.message.getGroupCreateError(), new TagResolver[]{Placeholder.parsed((String)"command", (String)label)});
                return;
            }
            String targetGroup = args[1];
            if (this.config.addGroup(targetGroup)) {
                this.message.send(sender, this.message.getGroupCreated(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup)});
            } else {
                this.message.send(sender, this.message.getGroupAlreadyExist(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup)});
            }
            return;
        }
        if (target.equalsIgnoreCase("delete")) {
            if (args.length == 1) {
                this.message.send(sender, this.message.getGroupRemoveError(), new TagResolver[]{Placeholder.parsed((String)"command", (String)label)});
                return;
            }
            String targetGroup = args[1];
            if (this.config.removeGroup(targetGroup)) {
                this.message.send(sender, this.message.getGroupRemoved(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup)});
            } else {
                this.message.send(sender, this.message.getGroupNotFound(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup)});
            }
            return;
        }
        if (target.equalsIgnoreCase("list")) {
            if (args.length == 1) {
                if (this.config.getPluginGroups() == null || this.config.getPluginGroups().isEmpty()) {
                    this.message.send(sender, this.message.getGroupListEmpty());
                } else {
                    this.message.send(sender, this.message.getGroupList(), new TagResolver[]{Placeholder.component((String)"groups", (ComponentLike)this.message.getGroupListComponent(this.config.getPluginGroups()))});
                }
                return;
            }
            String targetGroup = args[1];
            if (this.isValidGroup(sender, targetGroup)) {
                Set<String> plugins = this.config.getPluginsOfGroup(targetGroup);
                this.message.send(sender, this.message.getGroupPluginList(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup), Placeholder.component((String)"plugins", (ComponentLike)this.message.getPluginListComponent(plugins))});
            }
            return;
        }
        if (target.equalsIgnoreCase("add")) {
            if (args.length <= 2) {
                this.message.send(sender, this.message.getPluginAddToGroupError(), new TagResolver[]{Placeholder.parsed((String)"command", (String)label)});
                return;
            }
            String targetGroup = args[1];
            if (this.config.isGroupNonexistent(targetGroup)) {
                this.message.send(sender, this.message.getGroupNotFound(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup)});
                return;
            }
            String targetPlugin = args[2];
            if (this.config.addPluginToGroup(targetGroup, targetPlugin)) {
                this.message.send(sender, this.message.getPluginAddedToGroup(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup), Placeholder.parsed((String)"plugin", (String)targetPlugin)});
            } else {
                this.message.send(sender, this.message.getPluginAddToGroupError(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup), Placeholder.parsed((String)"plugin", (String)targetPlugin)});
            }
            return;
        }
        if (target.equalsIgnoreCase("remove")) {
            if (args.length == 1) {
                this.message.send(sender, this.message.getPluginRemoveFromGroupError(), new TagResolver[]{Placeholder.parsed((String)"command", (String)label)});
                return;
            }
            String targetGroup = args[1];
            if (this.isValidGroup(sender, targetGroup)) {
                String targetPlugin = args[2];
                if (this.config.removePluginFromGroup(targetGroup, targetPlugin)) {
                    this.message.send(sender, this.message.getPluginRemovedFromGroup(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup), Placeholder.parsed((String)"plugin", (String)targetPlugin)});
                } else {
                    this.message.send(sender, this.message.getPluginNotInGroupError(), new TagResolver[]{Placeholder.parsed((String)"group", (String)targetGroup), Placeholder.parsed((String)"plugin", (String)targetPlugin)});
                }
            }
            return;
        }
        if (target.equalsIgnoreCase("help")) {
            this.message.send(sender, this.message.getGroupHelp(), (TagResolver)Placeholder.parsed((String)"command", (String)label));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String @NotNull [] args) {
        if (args.length == 1) {
            return this.subcommands.stream().filter(s -> s.startsWith(args[0])).toList();
        }
        String target = args[0];
        if (target.equalsIgnoreCase("create") && args.length == 2) {
            return Stream.of("<group-name>").filter(s -> s.startsWith(args[1])).toList();
        }
        if (target.equalsIgnoreCase("delete") && args.length == 2) {
            return this.config.getPluginGroupList().stream().filter(s -> s.startsWith(args[1])).toList();
        }
        if (target.equalsIgnoreCase("list")) {
            if (args.length == 2) {
                return this.config.getPluginGroupList().stream().filter(s -> s.startsWith(args[1])).toList();
            }
            if (args.length == 3 && !this.config.isGroupNonexistent(args[2])) {
                return this.config.getPluginsOfGroup(args[2]).stream().filter(s -> s.startsWith(args[2])).toList();
            }
        }
        if (target.equalsIgnoreCase("add") || target.equalsIgnoreCase("remove")) {
            if (args.length == 2) {
                return this.config.getPluginGroupList().stream().filter(s -> s.startsWith(args[1])).toList();
            }
            if (args.length == 3 && target.equalsIgnoreCase("add")) {
                return this.config.getServerPlugins().stream().filter(s -> s.startsWith(args[2])).toList();
            }
            if (args.length == 3 && target.equalsIgnoreCase("remove") && !this.config.isGroupNonexistent(args[1])) {
                return this.config.getPluginsOfGroup(args[1]).stream().filter(s -> s.startsWith(args[2])).toList();
            }
        }
        return List.of();
    }

    private boolean isValidGroup(CommandSender sender, String groupName) {
        if (this.config.isGroupNonexistent(groupName)) {
            this.message.send(sender, this.message.getGroupNotFound(), new TagResolver[]{Placeholder.parsed((String)"group", (String)groupName)});
            return false;
        }
        if (this.config.isGroupEmpty(groupName)) {
            this.message.send(sender, this.message.getGroupHasNoPlugins(), new TagResolver[]{Placeholder.parsed((String)"group", (String)groupName)});
            return false;
        }
        return true;
    }
}

