/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CheckDependSubCommand
implements SubCommand {
    private final MessageManager message;

    @Contract(pure=true)
    public CheckDependSubCommand(@NotNull PluginControl plugin) {
        this.message = plugin.getMessageManager();
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String @NotNull [] args) {
        List softdepend;
        if (args.length < 1) {
            this.message.send(sender, this.message.getCheckDependError());
            return;
        }
        HashMap<String, List> dependCheck = new HashMap<String, List>();
        String targetPlugin = args[0];
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            String pluginName = plugin.getName();
            if (pluginName.equalsIgnoreCase(targetPlugin)) continue;
            PluginDescriptionFile description = plugin.getDescription();
            if (description.getDepend().contains(targetPlugin)) {
                dependCheck.computeIfAbsent("depend", k -> new ArrayList()).add(pluginName);
            }
            if (!description.getSoftDepend().contains(targetPlugin)) continue;
            dependCheck.computeIfAbsent("softdepend", k -> new ArrayList()).add(pluginName);
        }
        TagResolver.Single pluginTag = Placeholder.parsed((String)"plugin", (String)targetPlugin);
        if (dependCheck.isEmpty()) {
            this.message.send(sender, this.message.getCheckDependNotFound(), new TagResolver[]{pluginTag});
            return;
        }
        List depend = (List)dependCheck.get("depend");
        if (depend != null && !depend.isEmpty()) {
            Component dependMessage = this.message.getPluginListComponent(new HashSet<String>(depend));
            this.message.send(sender, this.message.getCheckDependDepend(), new TagResolver[]{pluginTag, Placeholder.component((String)"plugins", (ComponentLike)dependMessage)});
        }
        if ((softdepend = (List)dependCheck.get("softdepend")) != null && !softdepend.isEmpty()) {
            Component softdependMessage = this.message.getPluginListComponent(new HashSet<String>(softdepend));
            this.message.send(sender, this.message.getCheckDependSoftDepend(), new TagResolver[]{pluginTag, Placeholder.component((String)"plugins", (ComponentLike)softdependMessage)});
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String @NotNull [] args) {
        if (args.length == 1) {
            return Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(Plugin::getName).filter(s -> s.startsWith(args[0])).toList();
        }
        return List.of();
    }
}

