/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.ConfigManager;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AddSubCommand
implements SubCommand {
    private final ConfigManager config;
    private final MessageManager message;

    @Contract(pure=true)
    public AddSubCommand(@NotNull PluginControl plugin) {
        this.config = plugin.getConfigManager();
        this.message = plugin.getMessageManager();
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String @NotNull [] args) {
        if (args.length == 0 || args[0].isBlank()) {
            this.message.send(sender, this.message.getPluginAddError(), new TagResolver[]{Placeholder.parsed((String)"command", (String)label)});
            return;
        }
        String target = args[0];
        if (target.equals("all")) {
            this.config.addAllPlugins(this.config.getServerPlugins());
            this.message.send(sender, this.message.getAllPluginsAdded(), new TagResolver[]{Placeholder.component((String)"plugin", (ComponentLike)this.message.getPluginListComponent(this.config.getPluginList()))});
            return;
        }
        if (this.config.addPlugin(target)) {
            this.message.send(sender, this.message.getPluginAdded(), new TagResolver[]{Placeholder.parsed((String)"plugin", (String)target)});
        } else {
            this.message.send(sender, this.message.getPluginAlreadyAdded(), new TagResolver[]{Placeholder.parsed((String)"plugin", (String)target)});
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String @NotNull [] args) {
        if (args.length != 1) {
            return List.of();
        }
        return this.config.getServerPlugins().stream().filter(s -> s.startsWith(args[0])).toList();
    }
}

