/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands.subcommands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.managers.ConfigManager;
import com.armamc.plugincontrol.managers.MessageManager;
import com.armamc.plugincontrol.managers.PluginsManager;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ActionSubCommand
implements SubCommand {
    private final ConfigManager config;
    private final MessageManager message;
    private final PluginsManager manager;
    private final List<String> actions;

    @Contract(pure=true)
    public ActionSubCommand(@NotNull PluginControl plugin) {
        this.config = plugin.getConfigManager();
        this.message = plugin.getMessageManager();
        this.manager = plugin.getPluginsManager();
        this.actions = List.of("log-to-console", "disallow-player-login", "shutdown-server");
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String @NotNull [] args) {
        if (args.length == 0 || args[0].isBlank()) {
            this.message.send(sender, this.message.getActionType(), new TagResolver[]{Placeholder.parsed((String)"action", (String)this.config.getAction().toLowerCase())});
            return;
        }
        try {
            ConfigManager.ActionType actionType = ConfigManager.ActionType.from(args[0].toLowerCase());
            this.config.setAction(actionType);
            this.message.send(sender, this.message.getActionSet(), new TagResolver[]{Placeholder.parsed((String)"action", (String)actionType.getAction())});
            if (actionType != ConfigManager.ActionType.DISALLOW_PLAYER_LOGIN) {
                this.manager.unregisterListener();
            }
            this.manager.checkPlugins();
        }
        catch (IllegalArgumentException e) {
            this.message.send(sender, this.message.getActionTypeList(), new TagResolver[]{Placeholder.parsed((String)"actions", (String)String.join((CharSequence)", ", this.actions))});
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            return List.of();
        }
        return this.actions.stream().filter(s -> s.startsWith(args[0])).toList();
    }
}

