/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol.commands;

import com.armamc.plugincontrol.PluginControl;
import com.armamc.plugincontrol.commands.subcommands.ActionSubCommand;
import com.armamc.plugincontrol.commands.subcommands.AddSubCommand;
import com.armamc.plugincontrol.commands.subcommands.CheckDependSubCommand;
import com.armamc.plugincontrol.commands.subcommands.CheckSubCommand;
import com.armamc.plugincontrol.commands.subcommands.DisableSubCommand;
import com.armamc.plugincontrol.commands.subcommands.EnableSubCommand;
import com.armamc.plugincontrol.commands.subcommands.GroupSubCommand;
import com.armamc.plugincontrol.commands.subcommands.HelpSubCommand;
import com.armamc.plugincontrol.commands.subcommands.KickMessageSubCommand;
import com.armamc.plugincontrol.commands.subcommands.ListSubCommand;
import com.armamc.plugincontrol.commands.subcommands.ReloadSubCommand;
import com.armamc.plugincontrol.commands.subcommands.RemoveSubCommand;
import com.armamc.plugincontrol.commands.subcommands.SubCommand;
import com.armamc.plugincontrol.commands.subcommands.ToggleSubCommand;
import com.armamc.plugincontrol.managers.MessageManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private final MessageManager message;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public MainCommand(@NotNull PluginControl plugin) {
        this.message = plugin.getMessageManager();
        this.subCommands.put("enable", new EnableSubCommand(plugin));
        this.subCommands.put("disable", new DisableSubCommand(plugin));
        this.subCommands.put("check", new CheckSubCommand(plugin));
        this.subCommands.put("check-depend", new CheckDependSubCommand(plugin));
        this.subCommands.put("toggle", new ToggleSubCommand(plugin));
        this.subCommands.put("add", new AddSubCommand(plugin));
        this.subCommands.put("remove", new RemoveSubCommand(plugin));
        this.subCommands.put("list", new ListSubCommand(plugin));
        this.subCommands.put("action", new ActionSubCommand(plugin));
        this.subCommands.put("kick-message", new KickMessageSubCommand(plugin));
        this.subCommands.put("help", new HelpSubCommand(plugin));
        this.subCommands.put("reload", new ReloadSubCommand(plugin));
        this.subCommands.put("group", new GroupSubCommand(plugin));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 0) {
            this.message.send(sender, this.message.getHelpList(), (TagResolver)Placeholder.parsed((String)"command", (String)label));
            return true;
        }
        SubCommand subCommand = this.subCommands.get(args[0].toLowerCase());
        if (subCommand != null) {
            subCommand.execute(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
        } else {
            this.message.send(sender, this.message.getHelpList(), (TagResolver)Placeholder.parsed((String)"command", (String)label));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        SubCommand subCommand;
        if (args.length == 1) {
            Set<String> commands = this.subCommands.keySet();
            return commands.stream().filter(s -> s.startsWith(args[0])).toList();
        }
        if (args.length >= 2 && (subCommand = this.subCommands.get(args[0].toLowerCase())) != null) {
            return subCommand.tabComplete(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
        }
        return List.of();
    }
}

