/*
 * Decompiled with CFR 0.152.
 */
package com.armamc.plugincontrol;

import com.armamc.plugincontrol.commands.MainCommand;
import com.armamc.plugincontrol.managers.ConfigManager;
import com.armamc.plugincontrol.managers.MessageManager;
import com.armamc.plugincontrol.managers.PluginsManager;
import com.technicjelle.UpdateChecker;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PluginControl
extends JavaPlugin {
    private BukkitAudiences adventure;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private PluginsManager pluginsManager;

    public void onEnable() {
        this.registerConfig();
        this.registerCommands();
        this.registerTask();
        this.checkUpdate();
    }

    public void onDisable() {
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    private void registerConfig() {
        if (!this.getDataFolder().exists() && this.getDataFolder().mkdir()) {
            this.getLogger().info("Creating the plugin folder!");
        }
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.pluginsManager = new PluginsManager(this);
    }

    private void registerCommands() {
        MainCommand command = new MainCommand(this);
        PluginCommand pluginCommand = this.getCommand("plugincontrol");
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)command);
            pluginCommand.setTabCompleter((TabCompleter)command);
        }
    }

    private void registerTask() {
        Bukkit.getScheduler().runTaskLater((Plugin)this, this.pluginsManager::checkPlugins, 20L);
    }

    private void checkUpdate() {
        if (this.configManager.isUpdateNotifierEnabled()) {
            UpdateChecker updateChecker = new UpdateChecker("SrBedrock", "PluginControl", "1.3.0");
            updateChecker.checkAsync();
            updateChecker.logUpdateMessage(this.getLogger());
        }
    }

    @Contract(pure=true)
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Contract(pure=true)
    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    @Contract(pure=true)
    public PluginsManager getPluginsManager() {
        return this.pluginsManager;
    }

    @Contract(pure=true)
    @NotNull
    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public boolean isPluginEnabled(String pluginName) {
        Plugin plugin = this.getServer().getPluginManager().getPlugin(pluginName);
        return plugin != null && plugin.isEnabled();
    }
}

