/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.third_party.de.sprax2013.lime.spigot.third_party.de.sprax2013.advanced_dev_utils.events;

import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.spigot.third_party.de.sprax2013.advanced_dev_utils.events.ConnectionObserver;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.spigot.third_party.de.sprax2013.advanced_dev_utils.events.ObservedRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

abstract class PlayerManager {
    private final JavaPlugin plugin;
    private final Map<UUID, ConnectionObserver> connectionObserverMap = new HashMap<UUID, ConnectionObserver>();

    protected PlayerManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    protected abstract int schedule(JavaPlugin var1, ObservedRunnable var2);

    protected abstract void cancelTask(JavaPlugin var1, int var2);

    public void track(Player p) {
        UUID uuid = p.getUniqueId();
        if (this.connectionObserverMap.containsKey(uuid)) {
            this.unTrack(p);
        }
        ConnectionObserver observer = new ConnectionObserver(p){};
        observer.taskId = this.schedule(this.plugin, observer);
        this.connectionObserverMap.put(uuid, observer);
    }

    public ConnectionObserver unTrack(Player p) {
        ConnectionObserver observer = this.connectionObserverMap.remove(p.getUniqueId());
        if (observer != null) {
            observer.cancelled = true;
            this.cancelTask(this.plugin, observer.taskId);
        }
        return observer;
    }
}

