/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.third_party.de.sprax2013.lime.spigot.nms;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;

public class NmsVersionDetector {
    private static final Map<String, String> VERSION_TO_REVISION = new HashMap<String, String>();

    public static Optional<String> detect() {
        try {
            return Optional.of(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3]);
        }
        catch (Exception ex) {
            String minecraftVersion = Bukkit.getServer().getBukkitVersion().split("-")[0];
            return Optional.ofNullable(VERSION_TO_REVISION.get(minecraftVersion));
        }
    }

    static {
        VERSION_TO_REVISION.put("1.20", "v1_20_R1");
        VERSION_TO_REVISION.put("1.20.1", "v1_20_R1");
        VERSION_TO_REVISION.put("1.20.2", "v1_20_R2");
        VERSION_TO_REVISION.put("1.20.3", "v1_20_R3");
        VERSION_TO_REVISION.put("1.20.4", "v1_20_R3");
        VERSION_TO_REVISION.put("1.20.5", "v1_20_R4");
        VERSION_TO_REVISION.put("1.20.6", "v1_20_R4");
        VERSION_TO_REVISION.put("1.21", "v1_21_R1");
        VERSION_TO_REVISION.put("1.21.1", "v1_21_R1");
        VERSION_TO_REVISION.put("1.21.3", "v1_21_R2");
        VERSION_TO_REVISION.put("1.21.4", "v1_21_R3");
        VERSION_TO_REVISION.put("1.21.5", "v1_21_R4");
        VERSION_TO_REVISION.put("1.21.6", "v1_21_R5");
        VERSION_TO_REVISION.put("1.21.7", "v1_21_R5");
        VERSION_TO_REVISION.put("1.21.8", "v1_21_R5");
        VERSION_TO_REVISION.put("1.21.9", "v1_21_R6");
        VERSION_TO_REVISION.put("1.21.10", "v1_21_R6");
        VERSION_TO_REVISION.put("1.21.11", "v1_21_R7");
    }
}

