/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.validation;

import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.validation.EntryValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntEntryValidator
implements EntryValidator {
    private final MathSign mathSign;

    public IntEntryValidator(@Nullable MathSign mathSign) {
        this.mathSign = mathSign == null ? MathSign.IGNORE : mathSign;
    }

    @Override
    public boolean isValid(@Nullable Object value) {
        int parsedInt;
        if (value == null) {
            return false;
        }
        if (!(value instanceof Integer)) {
            try {
                parsedInt = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException ex) {
                return false;
            }
        } else {
            parsedInt = (Integer)value;
        }
        switch (this.mathSign) {
            case IGNORE: {
                return true;
            }
            case POSITIVE: {
                return parsedInt >= 0;
            }
            case POSITIVE_IGNORE_ZERO: {
                return parsedInt > 0;
            }
            case NEGATIVE: {
                return parsedInt <= 0;
            }
            case NEGATIVE_IGNORE_ZERO: {
                return parsedInt < 0;
            }
        }
        throw new RuntimeException("Could not process MathSign: " + (Object)((Object)this.mathSign));
    }

    @NotNull
    public static IntEntryValidator get() {
        return new IntEntryValidator(MathSign.IGNORE);
    }

    @NotNull
    public static IntEntryValidator get(@Nullable MathSign mathSign) {
        return new IntEntryValidator(mathSign);
    }

    public static enum MathSign {
        IGNORE,
        POSITIVE,
        POSITIVE_IGNORE_ZERO,
        NEGATIVE,
        NEGATIVE_IGNORE_ZERO;

    }
}

