/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs;

import de.sprax2013.betterchairs.BetterChairsPlugin;
import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class Updater
implements Listener {
    public static final String VERSION_TXT_URL = "https://spraxdev.github.io/BetterChairs/version.txt";
    public static final String MODRINTH_URL = "https://modrinth.com/plugin/betterchairs";
    public static final String HANGAR_URL = "https://hangar.papermc.io/Sprax/BetterChairs";
    public static final String SPIGOT_MC_URL = "https://r.spiget.org/84809";
    public static final String GITHUB_URL = "https://github.com/SpraxDev/BetterChairs/releases";
    public static final String CHANGELOG_URL = "https://github.com/SpraxDev/BetterChairs/blob/main/CHANGELOG.md";
    private final JavaPlugin plugin;
    private Timer timer;
    private String newerVersion;

    public Updater(JavaPlugin plugin) {
        this.plugin = plugin;
        Settings.getConfig().addListener(this::reInit);
        this.reInit();
    }

    private void reInit() {
        if (Settings.UPDATER_ENABLED.getValueAsBoolean()) {
            if (this.timer != null) {
                return;
            }
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (Updater.this.plugin.isEnabled() && Settings.UPDATER_ENABLED.getValueAsBoolean()) {
                        try {
                            Updater.this.checkForUpdates();
                        }
                        catch (Exception ex) {
                            ChairManager.getLogger().warning("Could not check for updates" + (ex.getMessage() == null ? "!" : ": " + ex.getMessage()));
                        }
                    } else {
                        Updater.this.timer.cancel();
                    }
                }
            }, 2000L, 10800000L);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        } else if (this.timer != null) {
            HandlerList.unregisterAll((Listener)this);
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void checkForUpdates() throws IOException {
        String inputLine;
        URL website = new URL(VERSION_TXT_URL);
        URLConnection connection = website.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder versionTxt = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            versionTxt.append(inputLine.trim());
        }
        in.close();
        String versionStr = versionTxt.toString().split("\n")[0];
        String currVersion = this.plugin.getDescription().getVersion();
        if (this.isNewerVersion(currVersion, versionStr)) {
            this.newerVersion = versionStr;
            ChairManager.getLogger().info(() -> String.format("Found a new update v%s -> v%s \u2014 Download the update from: %nmodrinth: %s%nHangar: %s%nSpigotMC: %s%nGitHub: %s%n%nChangelog: %s", currVersion, versionStr, MODRINTH_URL, HANGAR_URL, SPIGOT_MC_URL, GITHUB_URL, Updater.getChangelogUrl(versionStr)));
        } else {
            this.newerVersion = null;
        }
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent e) {
        if (this.newerVersion == null) {
            return;
        }
        if (!Settings.UPDATER_ENABLED.getValueAsBoolean()) {
            return;
        }
        if (!Settings.UPDATER_NOTIFY_ON_JOIN.getValueAsBoolean()) {
            return;
        }
        if (!e.getPlayer().hasPermission(this.plugin.getName() + ".updater")) {
            return;
        }
        e.getPlayer().spigot().sendMessage(new ComponentBuilder("[").color(ChatColor.GRAY).append(BetterChairsPlugin.getInstance().getName()).color(ChatColor.GOLD).append("] ").color(ChatColor.GRAY).append("Found a new update v" + this.plugin.getDescription().getVersion() + " -> v" + this.newerVersion).color(ChatColor.YELLOW).append(" [modrinth] ").color(ChatColor.GREEN).event(new ClickEvent(ClickEvent.Action.OPEN_URL, MODRINTH_URL)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a72Click to visit the download page on modrinth"))).append(" [Hangar] ").color(ChatColor.GREEN).event(new ClickEvent(ClickEvent.Action.OPEN_URL, HANGAR_URL)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a72Click to visit the download page on Hangar"))).append(" [SpigotMC] ").color(ChatColor.GREEN).event(new ClickEvent(ClickEvent.Action.OPEN_URL, SPIGOT_MC_URL)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a72Click to visit the download page on SpigotMC"))).append("[GitHub] ").color(ChatColor.GREEN).event(new ClickEvent(ClickEvent.Action.OPEN_URL, GITHUB_URL)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a72Click to visit the download page on GitHub"))).append("[Changelog]").color(ChatColor.DARK_GREEN).event(new ClickEvent(ClickEvent.Action.OPEN_URL, Updater.getChangelogUrl(this.newerVersion))).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a7aClick to see the Changelogs at GitHub.com"))).create());
    }

    @EventHandler
    private void onPluginDisable(PluginDisableEvent e) {
        if (e.getPlugin() == this.plugin) {
            this.timer.cancel();
        }
    }

    public boolean isNewerVersion(String ver1, String ver2) {
        int i;
        String[] ver1Args = ver1.split("-")[0].split("\\.");
        String[] ver2Args = ver2.split("-")[0].split("\\.");
        int[] ver1Num = new int[ver1Args.length];
        for (i = 0; i < ver1Args.length; ++i) {
            ver1Num[i] = Integer.parseInt(ver1Args[i]);
        }
        int[] ver2Num = new int[ver2Args.length];
        for (i = 0; i < ver2Args.length; ++i) {
            ver2Num[i] = Integer.parseInt(ver2Args[i]);
        }
        for (i = 0; i < Math.max(ver1Num.length, ver2Num.length); ++i) {
            int right;
            int left = i < ver1Num.length ? ver1Num[i] : 0;
            int n = right = i < ver2Num.length ? ver2Num[i] : 0;
            if (left == right) continue;
            return left < right;
        }
        if (ver1.contains("-")) {
            String suffix2;
            if (!ver2.contains("-")) {
                return true;
            }
            String suffix1 = ver1.substring(ver1.lastIndexOf(45));
            return !suffix1.equals(suffix2 = ver2.substring(ver2.lastIndexOf(45)));
        }
        return false;
    }

    private static String getChangelogUrl(@Nullable String semVersion) {
        if (semVersion != null) {
            return "https://github.com/SpraxDev/BetterChairs/blob/main/CHANGELOG.md#version-" + semVersion.replace(".", "");
        }
        return CHANGELOG_URL;
    }
}

