/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs;

import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.ChairNMS;
import de.sprax2013.betterchairs.third_party.com.cryptomorin.xseries.XMaterial;
import de.sprax2013.betterchairs.third_party.de.tr7zw.nbtapi.NBT;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.material.Directional;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ChairUtils {
    private ChairUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void applyChairProtections(Entity entity) {
        if (entity instanceof ArmorStand) {
            ((ArmorStand)entity).setGravity(false);
            ((ArmorStand)entity).setVisible(false);
        }
        if (entity instanceof Projectile) {
            ((Projectile)entity).setBounce(false);
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).setRemoveWhenFarAway(true);
        }
        try {
            NBT.modify(entity, nbt -> {
                try {
                    nbt.setBoolean("Invulnerable", true);
                    nbt.setInteger("Silent", 1);
                    if (entity instanceof ArmorStand) {
                        nbt.setInteger("DisabledSlots", 31);
                    }
                    if (entity instanceof Projectile) {
                        nbt.setBoolean("NoGravity", true);
                    }
                }
                catch (Throwable ex) {
                    ChairManager.getLogger().warning("Could not apply chair modifications (" + ex.getClass().getSimpleName() + ": " + ex.getMessage() + ")!");
                }
            });
        }
        catch (Throwable ex) {
            ChairManager.getLogger().warning("Could not apply chair modifications (" + ex.getClass().getSimpleName() + ": " + ex.getMessage() + ")!");
        }
    }

    public static BlockFace getBlockRotationLegacy(Block b) {
        try {
            BlockFace blockFace = ((Directional)b.getState().getData()).getFacing();
            if (blockFace == BlockFace.NORTH) {
                return BlockFace.SOUTH;
            }
            if (blockFace == BlockFace.SOUTH) {
                return BlockFace.NORTH;
            }
            if (blockFace == BlockFace.WEST) {
                return BlockFace.EAST;
            }
            if (blockFace == BlockFace.EAST) {
                return BlockFace.WEST;
            }
            return blockFace;
        }
        catch (Exception exception) {
            return BlockFace.SELF;
        }
    }

    public static boolean didChairEntityMove(Location expected, double actualX, double actualY, double actualZ) {
        return actualX != expected.getX() || actualY != expected.getY() || actualZ != expected.getZ();
    }

    public static void applyRegeneration(HumanEntity p, int regenerationAmplifier) {
        if (regenerationAmplifier >= 0 && !p.hasPotionEffect(PotionEffectType.REGENERATION)) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 60, regenerationAmplifier, false, false), true);
        }
    }

    public static double getSitOffset(Block block, boolean sitsOnArmorStand, ChairNMS chairNMS) {
        double yOffset = !chairNMS.isStair(block) && !chairNMS.isSlab(block) || chairNMS.isSlab(block) && chairNMS.isSlabTop(block) ? 0.5 : 0.0;
        XMaterial blockType = XMaterial.matchXMaterial(block.getType());
        if (blockType.name().endsWith("_TRAPDOOR")) {
            yOffset = -0.25;
        }
        return -1.2 + yOffset + (double)(!sitsOnArmorStand ? 1 : 0);
    }
}

