/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs;

import de.sprax2013.betterchairs.BetterChairsPlugin;
import de.sprax2013.betterchairs.Messages;
import de.sprax2013.betterchairs.Settings;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class BetterChairsCommand
implements CommandExecutor,
TabCompleter {
    private final String permsSit;
    private final String permsToggle;
    private final String permsReload;
    private final String permsReset;

    protected BetterChairsCommand(JavaPlugin plugin) {
        this.permsSit = plugin.getName() + ".cmd.sit";
        this.permsToggle = plugin.getName() + ".cmd.toggle";
        this.permsReload = plugin.getName() + ".cmd.reload";
        this.permsReset = plugin.getName() + ".cmd.reset";
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender.hasPermission(this.permsToggle) || sender.hasPermission(this.permsReload) || sender.hasPermission(this.permsReset) || sender.hasPermission(this.permsSit))) {
            sender.sendMessage(Messages.getString(Messages.NO_PERMISSION));
        }
        boolean showHelp = false;
        if (cmd.getName().equalsIgnoreCase("toggleChairs")) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("on") || args[0].equalsIgnoreCase("off")) {
                    this.handleToggleChairs(sender, args[0].equalsIgnoreCase("off"));
                } else if (args[0].equalsIgnoreCase("status")) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(Messages.getPrefix() + " \u00a7cOnly players may toggle chairs");
                        return true;
                    }
                    sender.sendMessage(Messages.getString(BetterChairsPlugin.getManager().hasChairsDisabled((OfflinePlayer)((Player)sender)) ? Messages.TOGGLE_STATUS_DISABLED : Messages.TOGGLE_STATUS_ENABLED));
                } else {
                    showHelp = true;
                }
            } else {
                this.handleToggleChairs(sender);
            }
        } else if (cmd.getName().equalsIgnoreCase("sit")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Messages.getPrefix() + " \u00a7cOnly players are able to sit");
                return true;
            }
            Player p = (Player)sender;
            Block b = null;
            if (p.getLocation().getBlock().getType().isSolid()) {
                b = p.getLocation().getBlock();
            } else if (p.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                b = p.getLocation().getBlock().getRelative(BlockFace.DOWN);
            }
            if (b != null) {
                BetterChairsPlugin.getManager().create(p, b);
            } else {
                sender.sendMessage(Messages.getPrefix() + " \u00a7cYou need to be on solid ground");
            }
        } else if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("toggle")) {
                this.handleToggleChairs(sender);
            } else if (args[0].equalsIgnoreCase("on") || args[0].equalsIgnoreCase("off")) {
                this.handleToggleChairs(sender, args[0].equalsIgnoreCase("off"));
            } else if (args[0].equalsIgnoreCase("status")) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(Messages.getPrefix() + " \u00a7cOnly players may toggle chairs");
                    return true;
                }
                sender.sendMessage(Messages.getString(BetterChairsPlugin.getManager().hasChairsDisabled((OfflinePlayer)((Player)sender)) ? Messages.TOGGLE_STATUS_DISABLED : Messages.TOGGLE_STATUS_ENABLED));
            } else if (args[0].equalsIgnoreCase("reload") || args[0].equalsIgnoreCase("rl")) {
                if (sender.hasPermission(this.permsReload)) {
                    if (Messages.reload()) {
                        sender.sendMessage(Messages.getPrefix() + " \u00a7aSuccessfully reloaded \u00a76messages.yml\u00a7a!");
                    } else {
                        sender.sendMessage(Messages.getPrefix() + " \u00a7cCould not reload \u00a76messages.yml \u00a77- \u00a7cCheck server logs for more information");
                    }
                    if (Settings.reload()) {
                        sender.sendMessage(Messages.getPrefix() + " \u00a7aSuccessfully reloaded \u00a76config.yml\u00a7a!");
                    } else {
                        sender.sendMessage(Messages.getPrefix() + " \u00a7cCould not reload \u00a76config.yml \u00a77- \u00a7cCheck server logs for more information");
                    }
                } else {
                    sender.sendMessage(Messages.getString(Messages.NO_PERMISSION));
                }
            } else if (args[0].equalsIgnoreCase("reset")) {
                if (sender.hasPermission(this.permsReset)) {
                    int chairCount = BetterChairsPlugin.getManager().destroyAll(true);
                    if (chairCount > 0) {
                        sender.sendMessage(Messages.getPrefix() + " \u00a7aSuccessfully removed \u00a76" + chairCount + " players\u00a7a from their chairs");
                    } else {
                        sender.sendMessage(Messages.getPrefix() + " \u00a74There are no chairs that could be removed");
                    }
                } else {
                    sender.sendMessage(Messages.getString(Messages.NO_PERMISSION));
                }
            } else {
                showHelp = true;
            }
        } else {
            showHelp = true;
        }
        if (showHelp) {
            sender.sendMessage(Messages.getPrefix() + " \u00a73/" + cmd.getName() + " toggle \u00a77(\u00a7eor \u00a73/bct\u00a77, \u00a73/toggleChairs\u00a77)");
            sender.sendMessage(Messages.getPrefix() + " \u00a73/" + cmd.getName() + " on\u00a77/\u00a73off \u00a77(\u00a7eor \u00a73/bct on\u00a77/\u00a73off\u00a77)");
            sender.sendMessage(Messages.getPrefix() + " \u00a73/" + cmd.getName() + " reload\u00a77/\u00a73rl");
            sender.sendMessage(Messages.getPrefix() + " \u00a73/" + cmd.getName() + " reset");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        if (!cmd.getName().equalsIgnoreCase("sit") && args.length == 1) {
            String arg = args[0].toLowerCase();
            if (sender.hasPermission(this.permsToggle)) {
                if ("toggle".startsWith(arg)) {
                    result.add("toggle");
                }
                if ("on".startsWith(arg)) {
                    result.add("on");
                }
                if ("off".startsWith(arg)) {
                    result.add("off");
                }
                if ("status".startsWith(arg)) {
                    result.add("status");
                }
            }
            if (!cmd.getName().equalsIgnoreCase("toggleChairs")) {
                if ("reload".startsWith(arg) && sender.hasPermission(this.permsReload)) {
                    result.add("reload");
                }
                if ("reset".startsWith(arg) && sender.hasPermission(this.permsReset)) {
                    result.add("reset");
                }
            }
        }
        return result;
    }

    private void handleToggleChairs(CommandSender sender) {
        this.handleToggleChairs(sender, sender instanceof Player && !BetterChairsPlugin.getManager().hasChairsDisabled((OfflinePlayer)((Player)sender)));
    }

    private void handleToggleChairs(CommandSender sender, boolean disableChairs) {
        if (!sender.hasPermission(this.permsToggle)) {
            sender.sendMessage(Messages.getString(Messages.NO_PERMISSION));
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(Messages.getPrefix() + " \u00a7cOnly players may toggle chairs");
            return;
        }
        BetterChairsPlugin.getManager().setChairsDisabled((Player)sender, disableChairs);
        sender.sendMessage(Messages.getString(disableChairs ? Messages.TOGGLE_DISABLED : Messages.TOGGLE_ENABLED));
    }
}

