/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.nms.v1_8_R1;

import de.sprax2013.betterchairs.ChairUtils;
import de.sprax2013.betterchairs.CustomChairEntity;
import net.minecraft.server.v1_8_R1.EntityArrow;
import net.minecraft.server.v1_8_R1.EntityHuman;
import net.minecraft.server.v1_8_R1.World;
import org.bukkit.entity.HumanEntity;

class CustomArrow
extends EntityArrow
implements CustomChairEntity {
    private boolean remove = false;
    private final int regenerationAmplifier;

    public CustomArrow(World world, double d0, double d1, double d2, int regenerationAmplifier) {
        super(world, d0, d1, d2);
        this.regenerationAmplifier = regenerationAmplifier;
    }

    @Override
    public void markAsRemoved() {
        this.remove = true;
    }

    public void s_() {
        if (this.remove) {
            return;
        }
        if (this.ticksLived % 10 == 0) {
            return;
        }
        if (!(this.passenger instanceof EntityHuman)) {
            this.remove = true;
            this.bukkitEntity.remove();
            return;
        }
        this.setYawPitch(this.passenger.yaw, 0.0f);
        ChairUtils.applyRegeneration((HumanEntity)((EntityHuman)this.passenger).getBukkitEntity(), this.regenerationAmplifier);
    }

    public void die() {
        if (this.shouldDie()) {
            super.die();
        }
    }

    private boolean shouldDie() {
        return this.remove || this.passenger == null || !(this.passenger instanceof EntityHuman);
    }
}

