/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.nms.v1_19_0;

import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.ChairUtils;
import de.sprax2013.betterchairs.CustomChairEntity;
import de.sprax2013.betterchairs.nms.v1_19_0.CustomArmorStand;
import de.sprax2013.betterchairs.nms.v1_19_0.CustomArrow;
import java.util.Objects;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;

public class v1_19_0 {
    @NotNull
    public Entity spawnChairEntity(@NotNull Location loc, int regenerationAmplifier, boolean useArmorStand) {
        WorldServer nmsWorld = ((CraftWorld)Objects.requireNonNull(loc.getWorld())).getHandle();
        CustomChairEntity nmsEntity = useArmorStand ? new CustomArmorStand(nmsWorld, loc.getX(), loc.getY(), loc.getZ(), regenerationAmplifier) : new CustomArrow(nmsWorld, loc.getX(), loc.getY() + 0.3, loc.getZ() + 0.25, regenerationAmplifier);
        CraftEntity bukkitEntity = nmsEntity.getBukkitEntity();
        ChairUtils.applyChairProtections((Entity)bukkitEntity);
        if (!nmsWorld.addFreshEntity((net.minecraft.world.entity.Entity)nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM)) {
            ChairManager.getLogger().warning("Looks like another plugin is preventing BetterChairs from spawning chairs");
        }
        return bukkitEntity;
    }

    public void killChairEntity(@NotNull Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof CustomChairEntity)) {
            throw new IllegalArgumentException(String.format("The provided Entity is not an instance of '%s'", CustomChairEntity.class.getName()));
        }
        ((CustomChairEntity)nmsEntity).markAsRemoved();
        entity.remove();
    }
}

