/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.nms.v1_18_R1;

import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.ChairNMS;
import de.sprax2013.betterchairs.ChairUtils;
import de.sprax2013.betterchairs.CustomChairEntity;
import de.sprax2013.betterchairs.nms.v1_18_R1.CustomArmorStand;
import de.sprax2013.betterchairs.nms.v1_18_R1.CustomArrow;
import java.util.Objects;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;

public class v1_18_R1
extends ChairNMS {
    @Override
    @NotNull
    public Entity spawnChairEntity(@NotNull Location loc, int regenerationAmplifier, boolean useArmorStand) {
        WorldServer nmsWorld = ((CraftWorld)Objects.requireNonNull(loc.getWorld())).getHandle();
        CustomChairEntity nmsEntity = useArmorStand ? new CustomArmorStand((World)nmsWorld, loc.getX(), loc.getY(), loc.getZ(), regenerationAmplifier) : new CustomArrow((World)nmsWorld, loc.getX(), loc.getY() + 0.3, loc.getZ() + 0.25, regenerationAmplifier);
        CraftEntity bukkitEntity = nmsEntity.getBukkitEntity();
        ChairUtils.applyChairProtections((Entity)bukkitEntity);
        if (!nmsWorld.addFreshEntity((net.minecraft.world.entity.Entity)nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM)) {
            ChairManager.getLogger().warning("Looks like another plugin is preventing BetterChairs from spawning chairs");
        }
        return bukkitEntity;
    }

    @Override
    public void killChairEntity(@NotNull Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof CustomChairEntity)) {
            throw new IllegalArgumentException(String.format("The provided Entity is not an instance of '%s'", CustomChairEntity.class.getName()));
        }
        ((CustomChairEntity)nmsEntity).markAsRemoved();
        entity.remove();
    }

    @Override
    public boolean isStair(@NotNull Block block) {
        return block.getBlockData() instanceof Stairs;
    }

    @Override
    public boolean isStairUpsideDown(@NotNull Block block) {
        return ((Stairs)block.getBlockData()).getHalf() == Bisected.Half.TOP;
    }

    @Override
    @NotNull
    public BlockFace getBlockRotation(@NotNull Block block) {
        return ((Directional)block.getBlockData()).getFacing();
    }

    @Override
    public boolean isSlab(@NotNull Block block) {
        return block.getBlockData() instanceof Slab && ((Slab)block.getBlockData()).getType() != Slab.Type.DOUBLE;
    }

    @Override
    public boolean isSlabTop(@NotNull Block block) {
        return ((Slab)block.getBlockData()).getType() == Slab.Type.TOP;
    }

    @Override
    public boolean hasEmptyMainHand(@NotNull Player player) {
        return player.getInventory().getItemInMainHand().getType() == Material.AIR;
    }

    @Override
    public boolean isChair(@NotNull Entity entity) {
        return ((CraftEntity)entity).getHandle() instanceof CustomChairEntity;
    }
}

