/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.nms.v1_17_R1;

import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.ChairUtils;
import de.sprax2013.betterchairs.CustomChairEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.plugin.Plugin;

class CustomArrow
extends EntityTippedArrow
implements CustomChairEntity {
    private boolean remove = false;
    private final int regenerationAmplifier;

    public CustomArrow(World world, double d0, double d1, double d2, int regenerationAmplifier) {
        super(world, d0, d1, d2);
        this.regenerationAmplifier = regenerationAmplifier;
    }

    @Override
    public void markAsRemoved() {
        this.remove = true;
    }

    public void tick() {
        Entity passenger;
        if (this.remove) {
            return;
        }
        if (this.R % 10 == 0) {
            return;
        }
        Entity entity = passenger = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (!(passenger instanceof EntityHuman)) {
            this.remove = true;
            this.getBukkitEntity().remove();
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)ChairManager.getPlugin(), () -> this.getBukkitEntity().setRotation(passenger.getBukkitYaw(), 0.0f));
        ChairUtils.applyRegeneration((HumanEntity)((EntityHuman)passenger).getBukkitEntity(), this.regenerationAmplifier);
    }

    public void killEntity() {
        if (this.shouldDie()) {
            super.killEntity();
        }
    }

    public void a(Entity.RemovalReason removalReason) {
        if (this.shouldDie()) {
            super.a(removalReason);
        }
    }

    private boolean shouldDie() {
        return this.remove || this.getPassengers().isEmpty() || !(this.getPassengers().get(0) instanceof EntityHuman);
    }
}

