/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.breeding.elements;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.LivingEntity;

@Name(value="Is Adult")
@Description(value={"Checks whether or not a living entity is an adult."})
@Example(value="on drink:\n\tevent-entity is not an adult\n\tkill event-entity\n")
@Since(value={"2.10"})
public class CondIsAdult
extends PropertyCondition<LivingEntity> {
    @Override
    public boolean check(LivingEntity entity) {
        Ageable ageable;
        return entity instanceof Ageable && (ageable = (Ageable)entity).isAdult();
    }

    @Override
    protected String getPropertyName() {
        return "an adult";
    }

    static {
        CondIsAdult.register(CondIsAdult.class, "[an] adult", "livingentities");
    }
}

