/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.base.types;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.util.Experience;
import ch.njol.skript.util.Utils;
import ch.njol.util.coll.CollectionUtils;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.properties.Property;
import org.skriptlang.skript.lang.properties.handlers.base.ExpressionPropertyHandler;

@ApiStatus.Internal
public class EntityClassInfo
extends ClassInfo<Entity> {
    public EntityClassInfo() {
        super(Entity.class, "entity");
        this.user("entit(y|ies)").name("Entity").description("An entity is something in a <a href='#world'>world</a> that's not a <a href='#block'>block</a>, e.g. a <a href='#player'>player</a>, a skeleton, or a zombie, but also <a href='#projectile'>projectiles</a> like arrows, fireballs or thrown potions, or special entities like dropped items, falling blocks or paintings.").usage("player, op, wolf, tamed ocelot, powered creeper, zombie, unsaddled pig, fireball, arrow, dropped item, item frame, etc.").examples("entity is a zombie or creeper", "player is an op", "projectile is an arrow", "shoot a fireball from the player").since("1.0").defaultExpression(new EventValueExpression<Entity>(Entity.class)).parser(new EntityParser()).changer(new EntityChanger()).property(Property.NAME, "The entity's custom name, if it has one, as text. Can be set or reset.", Skript.instance(), new EntityNameHandler(Property.NAME)).property(Property.DISPLAY_NAME, "The entity's custom name, if it has one, as text. Can be set or reset.", Skript.instance(), new EntityNameHandler(Property.DISPLAY_NAME));
    }

    private static class EntityParser
    extends Parser<Entity> {
        private EntityParser() {
        }

        @Override
        @Nullable
        public Entity parse(String s, ParseContext context) {
            if (Utils.isValidUUID(s)) {
                return Bukkit.getEntity((UUID)UUID.fromString(s));
            }
            return null;
        }

        @Override
        public boolean canParse(ParseContext context) {
            return context == ParseContext.COMMAND || context == ParseContext.PARSE;
        }

        @Override
        public String toVariableNameString(Entity entity) {
            return "entity:" + entity.getUniqueId().toString().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public String toString(Entity e, int flags) {
            return EntityData.toString(e, flags);
        }
    }

    public static class EntityChanger
    implements Changer<Entity> {
        @Override
        public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
            return switch (mode) {
                default -> throw new MatchException(null, null);
                case Changer.ChangeMode.ADD -> CollectionUtils.array(ItemType[].class, Inventory.class, Experience[].class);
                case Changer.ChangeMode.DELETE -> CollectionUtils.array(new Class[0]);
                case Changer.ChangeMode.REMOVE -> CollectionUtils.array(PotionEffectType[].class, ItemType[].class, Inventory.class);
                case Changer.ChangeMode.REMOVE_ALL -> CollectionUtils.array(PotionEffectType[].class, ItemType[].class);
                case Changer.ChangeMode.SET, Changer.ChangeMode.RESET -> null;
            };
        }

        public void change(Entity[] entities, Object @Nullable [] delta, Changer.ChangeMode mode) {
            if (delta == null) {
                for (Entity entity : entities) {
                    if (entity instanceof Player) continue;
                    entity.remove();
                }
                return;
            }
            boolean hasItem = false;
            for (Entity entity : entities) {
                for (Object deltaObj : delta) {
                    if (deltaObj instanceof PotionEffectType) {
                        PotionEffectType potionEffectType = (PotionEffectType)deltaObj;
                        assert (mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL);
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.removePotionEffect(potionEffectType);
                        continue;
                    }
                    if (!(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    if (deltaObj instanceof Experience) {
                        Experience experience = (Experience)deltaObj;
                        player.giveExp(experience.getXP());
                        continue;
                    }
                    if (deltaObj instanceof Inventory) {
                        Inventory itemStacks = (Inventory)deltaObj;
                        PlayerInventory inventory = player.getInventory();
                        for (ItemStack itemStack : itemStacks) {
                            if (itemStack == null) continue;
                            if (mode == Changer.ChangeMode.ADD) {
                                inventory.addItem(new ItemStack[]{itemStack});
                                continue;
                            }
                            inventory.remove(itemStack);
                        }
                        continue;
                    }
                    if (!(deltaObj instanceof ItemType)) continue;
                    ItemType itemType = (ItemType)deltaObj;
                    hasItem = true;
                    PlayerInventory invi = player.getInventory();
                    if (mode == Changer.ChangeMode.ADD) {
                        itemType.addTo((Inventory)invi);
                        continue;
                    }
                    if (mode == Changer.ChangeMode.REMOVE) {
                        itemType.removeFrom((Inventory)invi);
                        continue;
                    }
                    itemType.removeAll((Inventory)invi);
                }
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!hasItem) continue;
                PlayerUtils.updateInventory(player);
            }
        }
    }

    private static class EntityNameHandler
    implements ExpressionPropertyHandler<Entity, String> {
        private final boolean displayName;

        public EntityNameHandler(Property<ExpressionPropertyHandler<?, ?>> property) {
            this.displayName = switch (property.name()) {
                case "name" -> false;
                case "display name" -> true;
                default -> throw new IllegalArgumentException("Property must be either NAME or DISPLAY_NAME");
            };
        }

        @Override
        public String convert(Entity propertyHolder) {
            if (this.displayName) {
                return propertyHolder.getCustomName();
            }
            return propertyHolder.getName();
        }

        @Override
        public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
                return CollectionUtils.array(String.class);
            }
            return null;
        }

        @Override
        public void change(Entity entity, Object @Nullable [] delta, Changer.ChangeMode mode) {
            String name;
            assert (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET);
            if (mode == Changer.ChangeMode.RESET) {
                name = null;
            } else {
                assert (delta != null);
                name = (String)delta[0];
            }
            entity.setCustomName(name);
            if (this.displayName || mode == Changer.ChangeMode.RESET) {
                entity.setCustomNameVisible(name != null);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.setRemoveWhenFarAway(name == null);
            }
        }

        @Override
        @NotNull
        public Class<String> returnType() {
            return String.class;
        }
    }
}

