/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventConverter;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.registration.DefaultSyntaxInfos;
import org.skriptlang.skript.registration.SyntaxInfo;
import org.skriptlang.skript.util.Priority;

public class EventValueExpression<T>
extends SimpleExpression<T>
implements DefaultExpression<T> {
    public static final Priority DEFAULT_PRIORITY = Priority.before(SyntaxInfo.COMBINED);
    private final Map<Class<? extends Event>, Converter<?, ? extends T>> converters = new HashMap();
    private final Map<Class<? extends Event>, EventConverter<Event, T>> eventConverters = new HashMap<Class<? extends Event>, EventConverter<Event, T>>();
    private final Class<?> componentType;
    private final Class<? extends T> type;
    @Nullable
    private Changer<? super T> changer;
    private final boolean single;
    private final boolean exact;
    private boolean isDelayed;

    public static <E extends EventValueExpression<T>, T> DefaultSyntaxInfos.Expression.Builder<? extends DefaultSyntaxInfos.Expression.Builder<?, E, T>, E, T> infoBuilder(Class<E> expressionClass, Class<T> returnType, String ... patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = "[the] " + patterns[i];
        }
        return (DefaultSyntaxInfos.Expression.Builder)((DefaultSyntaxInfos.Expression.Builder)DefaultSyntaxInfos.Expression.builder(expressionClass, returnType).priority(DEFAULT_PRIORITY)).addPatterns(patterns);
    }

    @Deprecated(since="2.14", forRemoval=true)
    public static <T> void register(Class<? extends EventValueExpression<T>> expression, Class<T> type, String pattern) {
        Skript.registerExpression(expression, type, ExpressionType.EVENT, "[the] " + pattern);
    }

    @Deprecated(since="2.14", forRemoval=true)
    public static <T> void register(Class<? extends EventValueExpression<T>> expression, Class<T> type, String ... patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (StringUtils.startsWithIgnoreCase(patterns[i], "[the] ")) continue;
            patterns[i] = "[the] " + patterns[i];
        }
        Skript.registerExpression(expression, type, ExpressionType.EVENT, patterns);
    }

    public EventValueExpression(Class<? extends T> type) {
        this(type, null);
    }

    public EventValueExpression(Class<? extends T> type, boolean exact) {
        this(type, null, exact);
    }

    public EventValueExpression(Class<? extends T> type, @Nullable Changer<? super T> changer) {
        this(type, changer, false);
    }

    public EventValueExpression(Class<? extends T> type, @Nullable Changer<? super T> changer, boolean exact) {
        assert (type != null);
        this.type = type;
        this.exact = exact;
        this.changer = changer;
        this.single = !type.isArray();
        this.componentType = this.single ? type : type.getComponentType();
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (expressions.length != 0) {
            throw new SkriptAPIException(this.getClass().getName() + " has expressions in its pattern but does not override init(...)");
        }
        return this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        ParserInstance parser = this.getParser();
        this.isDelayed = parser.getHasDelayBefore().isTrue();
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            boolean hasValue = false;
            Class<? extends Event>[] events = parser.getCurrentEvents();
            if (events == null) {
                assert (false);
                boolean bl = false;
                return bl;
            }
            for (Class<? extends Event> event : events) {
                if (this.converters.containsKey(event)) {
                    hasValue = this.converters.get(event) != null;
                    continue;
                }
                if (EventValues.hasMultipleConverters(event, this.type, this.getTime()) == Kleenean.TRUE) {
                    Noun typeName = Classes.getExactClassInfo(this.componentType).getName();
                    log.printError("There are multiple " + typeName.toString(true) + " in " + Utils.a(parser.getCurrentEventName()) + " event. You must define which " + String.valueOf(typeName) + " to use.");
                    boolean bl = false;
                    return bl;
                }
                Converter<Object, ? extends T> converter = this.exact ? EventValues.getExactEventValueConverter(event, this.type, this.getTime()) : EventValues.getEventValueConverter(event, this.type, this.getTime());
                if (converter == null) continue;
                this.converters.put(event, converter);
                hasValue = true;
                if (!(converter instanceof EventConverter)) continue;
                EventConverter eventConverter = (EventConverter)converter;
                this.eventConverters.put(event, eventConverter);
            }
            if (!hasValue) {
                log.printError("There's no " + Classes.getSuperClassInfo(this.componentType).getName().toString(!this.single) + " in " + Utils.a(parser.getCurrentEventName()) + " event");
                boolean bl = false;
                return bl;
            }
            log.printLog();
            boolean bl = true;
            return bl;
        }
        finally {
            log.stop();
        }
    }

    @Override
    @Nullable
    protected T[] get(Event event) {
        T value = this.getValue(event);
        if (value == null) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        if (this.single) {
            Object[] one = (Object[])Array.newInstance(this.type, 1);
            one[0] = value;
            return one;
        }
        Object[] dataArray = (Object[])value;
        Object[] array = (Object[])Array.newInstance(this.componentType, dataArray.length);
        System.arraycopy(dataArray, 0, array, 0, array.length);
        return array;
    }

    @Nullable
    private <E extends Event> T getValue(E event) {
        if (this.converters.containsKey(event.getClass())) {
            Converter<?, ? extends T> g = this.converters.get(event.getClass());
            return g == null ? null : (T)g.convert(event);
        }
        for (Map.Entry<Class<Event>, Converter<?, T>> p : this.converters.entrySet()) {
            if (!p.getKey().isAssignableFrom(event.getClass())) continue;
            this.converters.put(event.getClass(), p.getValue());
            return p.getValue() == null ? null : (T)p.getValue().convert(event);
        }
        this.converters.put(event.getClass(), null);
        return null;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && !this.eventConverters.isEmpty()) {
            if (this.isDelayed) {
                Skript.error("Event values cannot be changed after the event has already passed.");
                return null;
            }
            return CollectionUtils.array(this.type);
        }
        if (this.changer == null) {
            this.changer = Classes.getSuperClassInfo(this.componentType).getChanger();
        }
        return this.changer == null ? null : this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        EventConverter<Event, Object> converter;
        if (mode == Changer.ChangeMode.SET && (converter = this.eventConverters.get(event.getClass())) != null) {
            if (!this.type.isArray() && delta != null) {
                converter.set(event, delta[0]);
            } else {
                converter.set(event, delta);
            }
            return;
        }
        if (this.changer != null) {
            Changer.ChangerUtils.change(this.changer, this.getArray(event), delta, mode);
        }
    }

    @Override
    public boolean setTime(int time) {
        Class<? extends Event>[] events = this.getParser().getCurrentEvents();
        if (events == null) {
            assert (false);
            return false;
        }
        for (Class<? extends Event> event : events) {
            assert (event != null);
            boolean has = this.exact ? EventValues.doesExactEventValueHaveTimeStates(event, this.type) : EventValues.doesEventValueHaveTimeStates(event, this.type);
            if (!has) continue;
            super.setTime(time);
            this.converters.clear();
            this.init();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.componentType;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (!debug || event == null) {
            return "event-" + Classes.getSuperClassInfo(this.componentType).getName().toString(!this.single);
        }
        return Classes.getDebugMessage(this.getValue(event));
    }
}

