/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="MOTD")
@Description(value={"The message of the day in the server list. This can be changed in a <a href='#server_list_ping'>server list ping</a> event only.", "'default MOTD' returns the default MOTD always and can't be changed."})
@Example(value="on server list ping:\n\tset the motd to \"Join now!\"\n")
@Since(value={"2.3"})
public class ExprMOTD
extends SimpleExpression<String> {
    private static final boolean PAPER_EVENT_EXISTS;
    private boolean isDefault;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean isServerPingEvent;
        boolean bl = isServerPingEvent = this.getParser().isCurrentEvent((Class<? extends Event>)ServerListPingEvent.class) || PAPER_EVENT_EXISTS && this.getParser().isCurrentEvent((Class<? extends Event>)PaperServerListPingEvent.class);
        if (parseResult.mark == 2 && !isServerPingEvent) {
            Skript.error("The 'shown' MOTD expression can't be used outside of a server list ping event");
            return false;
        }
        this.isDefault = parseResult.mark == 0 && !isServerPingEvent || parseResult.mark == 1;
        return true;
    }

    @Nullable
    public String[] get(Event e) {
        if (!this.isDefault && !(e instanceof ServerListPingEvent)) {
            return null;
        }
        if (this.isDefault) {
            return CollectionUtils.array(Bukkit.getMotd());
        }
        return CollectionUtils.array(((ServerListPingEvent)e).getMotd());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.isDefault) {
            if (this.getParser().getHasDelayBefore().isTrue()) {
                Skript.error("Can't change the MOTD anymore after the server list ping event has already passed");
                return null;
            }
            switch (mode) {
                case SET: 
                case DELETE: 
                case RESET: {
                    return CollectionUtils.array(String.class);
                }
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(e instanceof ServerListPingEvent)) {
            return;
        }
        ServerListPingEvent event = (ServerListPingEvent)e;
        switch (mode) {
            case SET: {
                event.setMotd((String)delta[0]);
                break;
            }
            case DELETE: {
                event.setMotd("");
                break;
            }
            case RESET: {
                event.setMotd(Bukkit.getMotd());
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + (this.isDefault ? "default MOTD" : "MOTD");
    }

    static {
        Skript.registerExpression(ExprMOTD.class, String.class, ExpressionType.SIMPLE, "[the] [(1\u00a6default)|(2\u00a6shown|displayed)] (MOTD|message of [the] day)");
        PAPER_EVENT_EXISTS = Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
    }
}

