/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

@Name(value="Item with Lore")
@Description(value={"Returns the given item type with the specified lore added to it.", "If multiple strings are passed, each of them will be a separate line in the lore."})
@Example(value="\tset {_test} to stone with lore \"line 1\" and \"line 2\"\n\tgive {_test} to player\n")
@Since(value={"2.3"})
public class ExprItemWithLore
extends PropertyExpression<ItemType, ItemType> {
    private Expression<String> lore;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.lore = exprs[1];
        return true;
    }

    protected ItemType[] get(Event e, ItemType[] source) {
        List lore = this.lore.stream(e).flatMap(l -> Arrays.stream(l.split("\n"))).collect(Collectors.toList());
        return this.get(source, item -> {
            item = item.clone();
            ItemMeta meta = item.getItemMeta();
            meta.setLore(lore);
            item.setItemMeta(meta);
            return item;
        });
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.getExpr().toString(e, debug) + " with lore " + this.lore.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprItemWithLore.class, ItemType.class, ExpressionType.PROPERTY, "%itemtype% with [(a|the)] lore %strings%");
    }
}

