/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Enchantment Offer")
@Description(value={"The enchantment offer in enchant prepare events."})
@Example(value="on enchant prepare:\n\tsend \"Your enchantment offers are: %the enchantment offers%\" to player\n")
@Since(value={"2.5"})
@Events(value={"enchant prepare"})
@RequiredPlugins(value={"1.11 or newer"})
public class ExprEnchantmentOffer
extends SimpleExpression<EnchantmentOffer> {
    private Expression<Number> exprOfferNumber;
    private boolean all;
    private final Random rand = new Random();
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)PrepareItemEnchantEvent.class)) {
            Skript.error("Enchantment offers are only usable in enchant prepare events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (matchedPattern == 0) {
            this.all = true;
        } else {
            this.exprOfferNumber = exprs[0];
            this.all = false;
        }
        return true;
    }

    @Nullable
    protected EnchantmentOffer[] get(Event e) {
        if (!(e instanceof PrepareItemEnchantEvent)) {
            return null;
        }
        if (this.all) {
            return ((PrepareItemEnchantEvent)e).getOffers();
        }
        if (this.exprOfferNumber == null) {
            return new EnchantmentOffer[0];
        }
        if (this.exprOfferNumber.isSingle()) {
            Number offerNumber = this.exprOfferNumber.getSingle(e);
            if (offerNumber == null) {
                return new EnchantmentOffer[0];
            }
            int offer = offerNumber.intValue();
            if (offer < 1 || offer > ((PrepareItemEnchantEvent)e).getOffers().length) {
                return new EnchantmentOffer[0];
            }
            return new EnchantmentOffer[]{((PrepareItemEnchantEvent)e).getOffers()[offer - 1]};
        }
        ArrayList<EnchantmentOffer> offers = new ArrayList<EnchantmentOffer>();
        for (Number n : this.exprOfferNumber.getArray(e)) {
            int i = n.intValue();
            if (i < 1 && i > ((PrepareItemEnchantEvent)e).getOffers().length) continue;
            offers.add(((PrepareItemEnchantEvent)e).getOffers()[i - 1]);
        }
        return offers.toArray(new EnchantmentOffer[0]);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return CollectionUtils.array(EnchantmentType.class);
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        EnchantmentType et;
        if (delta == null && mode != Changer.ChangeMode.DELETE) {
            return;
        }
        EnchantmentType enchantmentType = et = mode != Changer.ChangeMode.DELETE ? (EnchantmentType)delta[0] : null;
        if (event instanceof PrepareItemEnchantEvent) {
            PrepareItemEnchantEvent e = (PrepareItemEnchantEvent)event;
            switch (mode) {
                case SET: {
                    if (this.all) {
                        for (int i = 0; i <= 2; ++i) {
                            EnchantmentOffer eo = e.getOffers()[i];
                            if (eo == null) {
                                e.getOffers()[i] = eo = new EnchantmentOffer(et.getType(), et.getLevel(), this.getCost(i + 1, e.getEnchantmentBonus()));
                                continue;
                            }
                            eo.setEnchantment(et.getType());
                            eo.setEnchantmentLevel(et.getLevel());
                        }
                    } else {
                        for (Number n : this.exprOfferNumber.getArray((Event)e)) {
                            int slot = n.intValue() - 1;
                            EnchantmentOffer eo = e.getOffers()[slot];
                            if (eo == null) {
                                e.getOffers()[slot] = eo = new EnchantmentOffer(et.getType(), et.getLevel(), this.getCost(slot + 1, e.getEnchantmentBonus()));
                                continue;
                            }
                            eo.setEnchantment(et.getType());
                            eo.setEnchantmentLevel(et.getLevel());
                        }
                    }
                    break;
                }
                case DELETE: {
                    if (this.all) {
                        Arrays.fill(e.getOffers(), null);
                        break;
                    }
                    for (Number n : this.exprOfferNumber.getArray((Event)e)) {
                        e.getOffers()[n.intValue() - 1] = null;
                    }
                    break;
                }
                case ADD: 
                case REMOVE: 
                case RESET: 
                case REMOVE_ALL: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return !this.all && this.exprOfferNumber.isSingle();
    }

    @Override
    public Class<? extends EnchantmentOffer> getReturnType() {
        return EnchantmentOffer.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.all ? "the enchantment offers" : "enchantment offer(s) " + this.exprOfferNumber.toString(e, debug);
    }

    public int getCost(int slot, int bookshelves) {
        int base = (int)((double)(this.rand.nextInt(7) + 1) + Math.floor(bookshelves / 2) + (double)this.rand.nextInt(bookshelves + 1));
        switch (slot) {
            case 1: {
                return Math.max(base / 3, 1);
            }
            case 2: {
                return base * 2 / 3 + 1;
            }
            case 3: {
                return Math.max(base, bookshelves * 2);
            }
        }
        return 1;
    }

    static {
        boolean bl = $assertionsDisabled = !ExprEnchantmentOffer.class.desiredAssertionStatus();
        if (Skript.classExists("org.bukkit.enchantments.EnchantmentOffer")) {
            Skript.registerExpression(ExprEnchantmentOffer.class, EnchantmentOffer.class, ExpressionType.SIMPLE, "[all [of]] [the] enchant[ment] offers", "enchant[ment] offer[s] %numbers%", "[the] %number%(st|nd|rd|th) enchant[ment] offer");
        }
    }
}

