/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Title - Reset")
@Description(value={"Resets the title of the player to the default values."})
@Example.Examples(value={@Example(value="reset the titles of all players"), @Example(value="reset the title")})
@Since(value={"2.3"})
public class EffResetTitle
extends Effect {
    private Expression<Player> recipients;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.recipients = exprs[0];
        return true;
    }

    @Override
    protected void execute(Event e) {
        for (Player recipient : this.recipients.getArray(e)) {
            recipient.resetTitle();
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "reset the title of " + this.recipients.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffResetTitle.class, "reset [the] title[s] [of %players%]", "reset [the] %players%'[s] title[s]");
    }
}

