/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprColoured;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Broadcast")
@Description(value={"Broadcasts a message to the server."})
@Example.Examples(value={@Example(value="broadcast \"Welcome %player% to the server!\""), @Example(value="broadcast \"Woah! It's a message!\"")})
@Since(value={"1.0, 2.6 (broadcasting objects), 2.6.1 (using advanced formatting)"})
public class EffBroadcast
extends Effect {
    private static final Pattern HEX_PATTERN = Pattern.compile("(?i)&x((?:&\\p{XDigit}){6})");
    private Expression<?> messageExpr;
    private Expression<?>[] messages;
    @Nullable
    private Expression<World> worlds;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression[] expressionArray;
        this.messageExpr = LiteralUtils.defendExpression(exprs[0]);
        if (this.messageExpr instanceof ExpressionList) {
            expressionArray = ((ExpressionList)this.messageExpr).getExpressions();
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = this.messageExpr;
        }
        this.messages = expressionArray;
        this.worlds = exprs[1];
        return LiteralUtils.canInitSafely(this.messageExpr);
    }

    @Override
    public void execute(Event event) {
        ArrayList<CommandSender> receivers = new ArrayList<CommandSender>();
        if (this.worlds == null) {
            receivers.addAll(Bukkit.getOnlinePlayers());
            receivers.add((CommandSender)Bukkit.getConsoleSender());
        } else {
            for (World world : this.worlds.getArray(event)) {
                receivers.addAll(world.getPlayers());
            }
        }
        for (Expression<?> expression : this.getMessages()) {
            ExprColoured coloured;
            if (expression instanceof VariableString) {
                VariableString variableString = (VariableString)expression;
                StringBuilder unformattedString = new StringBuilder();
                List<MessageComponent> messageComponents = variableString.getMessageComponents(event, unformattedString);
                if (!EffBroadcast.dispatchEvent(unformattedString.toString(), receivers)) continue;
                BaseComponent[] components = BungeeConverter.convert(messageComponents);
                receivers.forEach(receiver -> receiver.spigot().sendMessage(components));
                continue;
            }
            if (expression instanceof ExprColoured && (coloured = (ExprColoured)expression).isUnsafeFormat()) {
                for (Object realMessage : expression.getArray(event)) {
                    if (!EffBroadcast.dispatchEvent(Utils.replaceChatStyles((String)realMessage), receivers)) continue;
                    BaseComponent[] components = BungeeConverter.convert(ChatMessages.parse((String)realMessage));
                    receivers.forEach(receiver -> receiver.spigot().sendMessage(components));
                }
                continue;
            }
            for (Object messageObject : expression.getArray(event)) {
                String string;
                String realMessage;
                String string2 = realMessage = messageObject instanceof String ? (string = (String)messageObject) : Classes.toString(messageObject);
                if (!EffBroadcast.dispatchEvent(Utils.replaceChatStyles(realMessage), receivers)) continue;
                receivers.forEach(receiver -> receiver.sendMessage(realMessage));
            }
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "broadcast " + this.messageExpr.toString(event, debug) + (String)(this.worlds == null ? "" : " to " + this.worlds.toString(event, debug));
    }

    private Expression<?>[] getMessages() {
        if (this.messageExpr instanceof ExpressionList && !this.messageExpr.getAnd()) {
            return new Expression[]{CollectionUtils.getRandom(this.messages)};
        }
        return this.messages;
    }

    private static boolean dispatchEvent(String message, List<CommandSender> receivers) {
        Set<CommandSender> recipients = Set.copyOf(receivers);
        BroadcastMessageEvent broadcastEvent = Skript.isRunningMinecraft(1, 14) ? new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients) : new BroadcastMessageEvent(message, recipients);
        Bukkit.getPluginManager().callEvent((Event)broadcastEvent);
        return !broadcastEvent.isCancelled();
    }

    @Nullable
    private static String getRawString(Event event, Expression<? extends String> string) {
        if (string instanceof VariableString) {
            VariableString variableString = (VariableString)string;
            return variableString.toUnformattedString(event);
        }
        String rawString = string.getSingle(event);
        if (rawString == null) {
            return null;
        }
        if ((rawString = SkriptColor.replaceColorChar(rawString)).toLowerCase().contains("&x")) {
            rawString = StringUtils.replaceAll((CharSequence)rawString, HEX_PATTERN, matchResult -> "<#" + matchResult.group(1).replace("&", "") + ">");
        }
        return rawString;
    }

    static {
        Skript.registerEffect(EffBroadcast.class, "broadcast %objects% [(to|in) %-worlds%]");
    }
}

