/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.common.properties.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.docs.Origin;
import org.skriptlang.skript.lang.properties.Property;
import org.skriptlang.skript.lang.properties.PropertyBaseExpression;
import org.skriptlang.skript.lang.properties.handlers.WXYZHandler;
import org.skriptlang.skript.registration.DefaultSyntaxInfos;
import org.skriptlang.skript.registration.SyntaxRegistry;

public class PropExprWXYZ
extends PropertyBaseExpression<WXYZHandler<?, ?>> {
    private WXYZHandler.Axis axis;

    public static void register(SyntaxRegistry registry, Origin origin) {
        registry.register(SyntaxRegistry.EXPRESSION, ((DefaultSyntaxInfos.Expression.Builder)((DefaultSyntaxInfos.Expression.Builder)PropertyExpression.infoBuilder(PropExprWXYZ.class, Object.class, "(:x|:y|:z|:w)( |-)[component[s]|coord[inate][s]|dep:(pos[ition[s]]|loc[ation][s])]", "objects", false).origin(origin)).supplier(PropExprWXYZ::new)).build());
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.axis = WXYZHandler.Axis.valueOf(parseResult.tags.get(0).toUpperCase(Locale.ENGLISH));
        if (!super.init(expressions, matchedPattern, isDelayed, parseResult)) {
            return false;
        }
        ArrayList tempProperties = new ArrayList(this.properties.entrySet());
        for (Map.Entry entry : tempProperties) {
            Property.PropertyInfo propertyInfo = (Property.PropertyInfo)entry.getValue();
            Class type = (Class)entry.getKey();
            WXYZHandler handler = (WXYZHandler)propertyInfo.handler();
            if (!handler.supportsAxis(this.axis)) {
                this.properties.remove(type);
                continue;
            }
            ((WXYZHandler)propertyInfo.handler()).axis(this.axis);
        }
        if (this.properties.isEmpty()) {
            Skript.error("None of the types returned by " + String.valueOf(this.expr) + " have an " + this.axis.name().toLowerCase(Locale.ENGLISH) + " axis component.");
            return false;
        }
        if (parseResult.hasTag("dep")) {
            Skript.warning("Using 'pos[ition]' or 'loc[ation]' to refer to specific coordinates is deprecated and will be removed. Please use 'coord[inate]', 'component[s]' or just the axis name 'x of {loc}' instead.");
        }
        return true;
    }

    public WXYZHandler.Axis axis() {
        return this.axis;
    }

    @Override
    @NotNull
    public Property<WXYZHandler<?, ?>> getProperty() {
        return Property.WXYZ;
    }

    @Override
    public String getPropertyName() {
        return this.axis.name();
    }
}

