/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.tags.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Keywords;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Comparator;
import java.util.TreeSet;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.bukkit.tags.TagModule;
import org.skriptlang.skript.bukkit.tags.TagType;
import org.skriptlang.skript.bukkit.tags.sources.TagOrigin;

@Name(value="All Tags of a Type")
@Description(value={"Returns all the tags.", "`minecraft tag` will return only the vanilla tags, `datapack tag` will return only datapack-provided tags, `paper tag` will return only Paper's custom tags (if you are running Paper), and `custom tag` will look in the \"skript\" namespace for custom tags you've registered.", "You can also filter by tag types using \"item\", \"block\", or \"entity\"."})
@Example.Examples(value={@Example(value="broadcast minecraft tags"), @Example(value="send paper entity tags"), @Example(value="broadcast all block tags")})
@Since(value={"2.10"})
@Keywords(value={"blocks", "minecraft tag", "type", "category"})
public class ExprTagsOfType
extends SimpleExpression<Tag> {
    TagType<?>[] types;
    private TagOrigin origin;
    private boolean datapackOnly;

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = TagType.fromParseMark(parseResult.mark);
        this.origin = TagOrigin.fromParseTags(parseResult.tags);
        this.datapackOnly = this.origin == TagOrigin.BUKKIT && parseResult.hasTag("datapack");
        return true;
    }

    protected Tag<?> @Nullable [] get(Event event) {
        TreeSet<Tag> tags = new TreeSet<Tag>(Comparator.comparing(Keyed::key));
        for (TagType<?> type : this.types) {
            for (Tag<?> tag2 : TagModule.tagRegistry.getMatchingTags(this.origin, type, tag -> this.origin != TagOrigin.BUKKIT || this.datapackOnly ^ tag.getKey().getNamespace().equals("minecraft"))) {
                tags.add(tag2);
            }
        }
        return tags.toArray(new Tag[0]);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<Tag> getReturnType() {
        return Tag.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String registry = this.types.length > 1 ? "" : " " + this.types[0].toString();
        return "all of the " + this.origin.toString(this.datapackOnly) + registry + " tags";
    }

    static {
        Skript.registerExpression(ExprTagsOfType.class, Tag.class, ExpressionType.SIMPLE, "[all [[of] the]|the] " + TagOrigin.getFullPattern() + " " + TagType.getFullPattern() + " tags");
    }
}

