/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.particles;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.EnumParser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameEffect {
    public static final EnumParser<Effect> ENUM_UTILS = new EnumParser<Effect>(Effect.class, "game effect");
    private final Effect effect;
    @Nullable
    private Object data;
    static final String[] namesWithoutData = (String[])Arrays.stream(Effect.values()).filter(effect -> effect.getData() == null).map(Enum::name).toArray(String[]::new);

    public GameEffect(Effect effect) {
        this.effect = effect;
    }

    public static GameEffect parse(String input) {
        Effect effect = (Effect)ENUM_UTILS.parse(input.toLowerCase(Locale.ENGLISH), ParseContext.DEFAULT);
        if (effect == null) {
            return null;
        }
        if (effect.getData() != null) {
            Skript.error("The effect " + Classes.toString(effect) + " requires data and cannot be parsed directly. Use the Game Effect expression instead.");
            return null;
        }
        return new GameEffect(effect);
    }

    public Effect getEffect() {
        return this.effect;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public boolean setData(Object data) {
        if (this.effect.getData() != null && this.effect.getData().isInstance(data)) {
            this.data = data;
            return true;
        }
        if (this.effect == Effect.ELECTRIC_SPARK && data == null) {
            this.data = null;
            return true;
        }
        return false;
    }

    public void draw(@NotNull Location location, @Nullable Number radius) {
        if (this.effect.getData() != null && this.data == null) {
            return;
        }
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        if (radius == null) {
            location.getWorld().playEffect(location, this.effect, this.data);
        } else {
            location.getWorld().playEffect(location, this.effect, this.data, radius.intValue());
        }
    }

    public void drawForPlayer(Location location, @NotNull Player player) {
        player.playEffect(location, this.effect, this.data);
    }

    public String toString(int flags) {
        return ENUM_UTILS.toString(this.getEffect(), flags);
    }

    public String toString() {
        return this.toString(0);
    }

    public static String[] getAllNamesWithoutData() {
        return (String[])namesWithoutData.clone();
    }
}

