/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.misc.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.DisplayEntitySlot;
import ch.njol.skript.util.slot.DroppedItemSlot;
import ch.njol.skript.util.slot.ItemFrameSlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.skript.util.slot.ThrowableProjectileSlot;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.ThrowableProjectile;
import org.jetbrains.annotations.Nullable;

@Name(value="Item of an Entity")
@Description(value={"An item associated with an entity. For dropped item entities, it gets the item that was dropped.", "For item frames, the item inside the frame is returned.", "For throwable projectiles (snowballs, enderpearls etc.) or item displays, it gets the displayed item.", "Other entities do not have items associated with them."})
@Example.Examples(value={@Example(value="item of event-entity"), @Example(value="set the item inside of event-entity to a diamond sword named \"Example\"")})
@Since(value={"2.2-dev35, 2.2-dev36 (improved), 2.5.2 (throwable projectiles), 2.10 (item displays)"})
public class ExprItemOfEntity
extends SimplePropertyExpression<Entity, Slot> {
    @Override
    @Nullable
    public Slot convert(Entity entity) {
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            return new ItemFrameSlot(itemFrame);
        }
        if (entity instanceof Item) {
            Item item = (Item)entity;
            return new DroppedItemSlot(item);
        }
        if (entity instanceof ThrowableProjectile) {
            ThrowableProjectile throwableProjectile = (ThrowableProjectile)entity;
            return new ThrowableProjectileSlot(throwableProjectile);
        }
        if (entity instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            return new DisplayEntitySlot(itemDisplay);
        }
        return null;
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    protected String getPropertyName() {
        return "item inside";
    }

    static {
        ExprItemOfEntity.register(ExprItemOfEntity.class, Slot.class, "item [inside]", "entities");
    }
}

