/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.loottables.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.bukkit.loottables.LootTableUtils;

@Name(value="Loot Table")
@Description(value={"Returns the loot table of an entity or block.", "Setting the loot table of a block will update the block state, and once opened will generate loot of the specified loot table. Please note that doing so may cause warnings in the console due to over-filling the chest.", "Please note that resetting/deleting the loot table of an ENTITY will reset the entity's loot table to its default."})
@Example.Examples(value={@Example(value="set loot table of event-entity to \"minecraft:entities/ghast\"\n# this will set the loot table of the entity to a ghast's loot table, thus dropping ghast tears and gunpowder\n"), @Example(value="set loot table of event-block to \"minecraft:chests/simple_dungeon\"")})
@Since(value={"2.10"})
public class ExprLootTable
extends SimplePropertyExpression<Object, LootTable> {
    @Override
    @Nullable
    public LootTable convert(Object object) {
        if (LootTableUtils.isLootable(object)) {
            return LootTableUtils.getLootTable(object);
        }
        return null;
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> CollectionUtils.array(LootTable.class);
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        LootTable lootTable = delta != null ? (LootTable)delta[0] : null;
        for (Object object : this.getExpr().getArray(event)) {
            if (!LootTableUtils.isLootable(object)) continue;
            Lootable lootable = LootTableUtils.getAsLootable(object);
            lootable.setLootTable(lootTable);
            LootTableUtils.updateState(lootable);
        }
    }

    @Override
    public Class<? extends LootTable> getReturnType() {
        return LootTable.class;
    }

    @Override
    protected String getPropertyName() {
        return "loot table";
    }

    static {
        ExprLootTable.register(ExprLootTable.class, LootTable.class, "loot[ ]table[s]", "entities/blocks");
    }
}

