/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.itemcomponents.equippable;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.ItemSource;
import ch.njol.skript.util.slot.Slot;
import io.papermc.paper.datacomponent.item.Equippable;
import java.util.Arrays;
import java.util.function.Consumer;
import org.bukkit.inventory.ItemStack;
import org.skriptlang.skript.addon.AddonModule;
import org.skriptlang.skript.addon.SkriptAddon;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.EquippableWrapper;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.CondEquipCompDamage;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.CondEquipCompDispensable;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.CondEquipCompInteract;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.CondEquipCompShearable;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.CondEquipCompSwapEquipment;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.EffEquipCompDamageable;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.EffEquipCompDispensable;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.EffEquipCompInteract;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.EffEquipCompShearable;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.EffEquipCompSwapEquipment;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprEquipCompCameraOverlay;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprEquipCompEntities;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprEquipCompEquipSound;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprEquipCompModel;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprEquipCompShearSound;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprEquipCompSlot;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprEquippableComponent;
import org.skriptlang.skript.bukkit.itemcomponents.equippable.elements.ExprSecBlankEquipComp;
import org.skriptlang.skript.lang.converter.Converters;
import org.skriptlang.skript.registration.SyntaxRegistry;

public class EquippableModule
implements AddonModule {
    @Override
    public boolean canLoad(SkriptAddon addon) {
        return Skript.classExists("io.papermc.paper.datacomponent.item.Equippable");
    }

    @Override
    public void init(SkriptAddon addon) {
        Classes.registerClass(new ClassInfo<EquippableWrapper>(EquippableWrapper.class, "equippablecomponent").user("equippable ?components?").name("Equippable Components").description("Represents an equippable component used for items.\nNOTE: Equippable component elements are experimental. Thus, they are subject to change and may not work as intended.\n").requiredPlugins("Minecraft 1.21.2+").since("2.13").defaultExpression(new EventValueExpression<EquippableWrapper>(EquippableWrapper.class)).parser(new Parser<EquippableWrapper>(this){

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(EquippableWrapper wrapper, int flags) {
                return "equippable component";
            }

            @Override
            public String toVariableNameString(EquippableWrapper wrapper) {
                return "equippable component#" + wrapper.hashCode();
            }
        }).after("itemstack", "itemtype", "slot"));
        Converters.registerConverter(Equippable.class, EquippableWrapper.class, EquippableWrapper::new, 2);
        Converters.registerConverter(ItemStack.class, EquippableWrapper.class, EquippableWrapper::new, 2);
        Converters.registerConverter(ItemType.class, EquippableWrapper.class, itemType -> new EquippableWrapper(new ItemSource<ItemType>((ItemType)itemType)), 2);
        Converters.registerConverter(Slot.class, EquippableWrapper.class, slot -> {
            ItemSource<Slot> itemSource = ItemSource.fromSlot(slot);
            if (itemSource == null) {
                return null;
            }
            return new EquippableWrapper(itemSource);
        }, 2);
    }

    @Override
    public void load(SkriptAddon addon) {
        this.register(addon.syntaxRegistry(), CondEquipCompDamage::register, CondEquipCompDispensable::register, CondEquipCompInteract::register, CondEquipCompShearable::register, CondEquipCompSwapEquipment::register, EffEquipCompDamageable::register, EffEquipCompDispensable::register, EffEquipCompInteract::register, EffEquipCompShearable::register, EffEquipCompSwapEquipment::register, ExprEquipCompCameraOverlay::register, ExprEquipCompEntities::register, ExprEquipCompEquipSound::register, ExprEquipCompModel::register, ExprEquipCompShearSound::register, ExprEquipCompSlot::register, ExprEquippableComponent::register, ExprSecBlankEquipComp::register);
    }

    private void register(SyntaxRegistry registry, Consumer<SyntaxRegistry> ... consumers) {
        Arrays.stream(consumers).forEach(consumer -> consumer.accept(registry));
    }

    @Override
    public String name() {
        return "equippable component";
    }
}

