/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.displays.text;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;

@Name(value="Text Display Visible Through Blocks")
@Description(value={"Returns whether text displays can be seen through blocks or not."})
@Example(value="if last spawned text display is visible through walls:\n\tprevent last spawned text display from being visible through walls\n")
@Since(value={"2.10"})
public class CondTextDisplaySeeThroughBlocks
extends PropertyCondition<Display> {
    @Override
    public boolean check(Display value) {
        TextDisplay textDisplay;
        return value instanceof TextDisplay && (textDisplay = (TextDisplay)value).isSeeThrough();
    }

    @Override
    protected String getPropertyName() {
        return "visible through blocks";
    }

    static {
        CondTextDisplaySeeThroughBlocks.register(CondTextDisplaySeeThroughBlocks.class, "visible through (blocks|walls)", "displays");
    }
}

