/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.displays;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumClassInfo;
import ch.njol.skript.classes.data.DefaultChangers;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import java.io.IOException;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.skriptlang.skript.lang.converter.Converters;
import org.skriptlang.skript.lang.properties.Property;
import org.skriptlang.skript.lang.properties.handlers.base.ExpressionPropertyHandler;

public class DisplayModule {
    public static void load() throws IOException {
        if (!Skript.classExists("org.bukkit.entity.Display")) {
            return;
        }
        Skript.getAddonInstance().loadClasses("org.skriptlang.skript.bukkit", "displays");
        Classes.registerClass(new ClassInfo<Display>(Display.class, "display").user("displays?").name("Display Entity").description("A text, block or item display entity.").since("2.10").defaultExpression(new EventValueExpression<Display>(Display.class)).changer(DefaultChangers.nonLivingEntityChanger).property(Property.SCALE, "The scale multipliers to use for a displays. The x, y, and z scales of the display will be multiplied by the respective components of the vector.", Skript.instance(), new ExpressionPropertyHandler<Display, Vector>(){

            @Override
            @NotNull
            public Vector convert(Display propertyHolder) {
                return Vector.fromJOML((Vector3f)propertyHolder.getTransformation().getScale());
            }

            @Override
            public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
                return switch (mode) {
                    case Changer.ChangeMode.SET, Changer.ChangeMode.RESET -> CollectionUtils.array(Vector.class);
                    default -> null;
                };
            }

            @Override
            public void change(Display propertyHolder, Object @Nullable [] delta, Changer.ChangeMode mode) {
                Vector3f vector = null;
                if (mode == Changer.ChangeMode.RESET) {
                    vector = new Vector3f(1.0f, 1.0f, 1.0f);
                }
                if (delta != null) {
                    vector = ((Vector)delta[0]).toVector3f();
                }
                if (vector == null || !vector.isFinite()) {
                    return;
                }
                Transformation transformation = propertyHolder.getTransformation();
                Transformation change = new Transformation(transformation.getTranslation(), transformation.getLeftRotation(), vector, transformation.getRightRotation());
                propertyHolder.setTransformation(change);
            }

            @Override
            @NotNull
            public Class<Vector> returnType() {
                return Vector.class;
            }
        }));
        Classes.registerClass(new EnumClassInfo<Display.Billboard>(Display.Billboard.class, "billboard", "billboards").user("billboards?").name("Display Billboard").description("Represents the billboard setting of a display.").since("2.10"));
        Classes.registerClass(new EnumClassInfo<TextDisplay.TextAlignment>(TextDisplay.TextAlignment.class, "textalignment", "text alignments").user("text ?alignments?").name("Display Text Alignment").description("Represents the text alignment setting of a text display.").since("2.10"));
        Classes.registerClass(new EnumClassInfo<ItemDisplay.ItemDisplayTransform>(ItemDisplay.ItemDisplayTransform.class, "itemdisplaytransform", "item display transforms").user("item ?display ?transforms?").name("Item Display Transforms").description("Represents the transform setting of an item display.").since("2.10"));
        Converters.registerConverter(Entity.class, Display.class, entity -> {
            Display display;
            return entity instanceof Display ? (display = (Display)entity) : null;
        }, 2);
    }
}

