/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.breeding.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Adult/Baby")
@Description(value={"Force a animal to become an adult or baby."})
@Example(value="on spawn of mob:\n\tentity is not an adult\n\tmake entity an adult\n")
@Since(value={"2.10"})
public class EffMakeAdultOrBaby
extends Effect {
    private boolean adult;
    private Expression<LivingEntity> entities;

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.adult = parseResult.hasTag("adult");
        this.entities = expressions[0];
        return true;
    }

    @Override
    protected void execute(Event event) {
        for (LivingEntity entity : this.entities.getArray(event)) {
            if (!(entity instanceof Ageable)) continue;
            Ageable ageable = (Ageable)entity;
            if (this.adult) {
                ageable.setAdult();
                continue;
            }
            ageable.setBaby();
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "make " + String.valueOf(this.entities) + (this.adult ? " an adult" : " a baby");
    }

    static {
        Skript.registerEffect(EffMakeAdultOrBaby.class, "make %livingentities% [a[n]] (:adult|baby|child)", "force %livingentities% to be[come] a[n] (:adult|baby|child)");
    }
}

